ACCESS.SYS(8)           XROUTER REFERENCE MANUAL             28/2/2025

NAME
        ACCESS.SYS -- Telnet Access Control File.

DESCRIPTION
        This optional file is read only at bootup. It specifies
        TCP/IP access requirements according to the caller's IP
        address.  If not present, the default action is for 
        logins to require a valid callsign only.

FORMAT
        The entries in ACCESS.SYS are of the form:

              <subnet>[/bits] <access_flags>

              e.g. "44.0.0.0/8 1"

        The <subnet> and [bits] parameters define a range of IP
        addresses from whom Telnet connects will be accepted, and
        <access_flags> defines  the login requirements for that
        subnet.

        The [bits] parameter specifies how many bits, from left to
        right, of the source address should be matched against the
        corresponding <subnet> address.  For example, 44.131.0.0/16
        will test the source IP address against the left-most 16
        bits of 44.131.0.0, i.e. it will match any source address
        beginning with 44.131. And 0.0.0.0/0 will match any IP
        address, which is useful for specifying the default. The 
        chosen match will be the one with the highest [bits] value.
        If [bits] is not specified, it defaults to 32, i.e. an exact
        match is required.

        The <access_flags> parameter is the sum of these flag values.

              1       Valid callsigns only
              2       Password required
              4       Guest access allowed
              8       This IP address [range] is trusted

        Typical combinations are as follows:

        0 - Any "callsign" longer than 1 character is accepted, and
            no password is required.  In this context, "callsign"
            could be a user name.  This is a zero security option,
            for use only for the sysop's convenience on physically
            secure subnets.

        1 - The user is required to enter a valid amateur radio
            callsign, i.e. a string containing alphanumeric
            characters in the  correct format, but no password is
            required.  This is a low security configuration with
            minimal inconvenience, and is suitable for use within
            amateur radio subnets which are not connected to the
             Internet. This configuration is recommended for callers
            who have 44.x.x.x source address, as they are presumed
            to have entered the network via radio, or via a
            password-protected gateway.

        2 - XRouter will accept any "username" longer than one
            character, providing a valid password is given.  This is
            a medium security configuration, suitable for use on
            private wire subnets where amateur radio callsigns are
            not used.

        3 - Both a valid amateur radio callsign and a matching
            password must be supplied. This configuration is
            recommended for use at the Internet-to-Amprnet interface,
            i.e. for all source IP addresses other than 44.x.x.x

        4 - Any "callsign" longer than 1 character is accepted, and
            no password is requested or required. All users have
            guest access, ie they cannot downlink.

        5 - The user is required to enter a valid amateur radio
            callsign, but no password is requested or required. All
            users have guest access, ie they cannot downlink.

        6 - Any "callsign" longer than 1 character is accepted.
            User is challenged to enter a password, but the option
            to use the password "guest" is available.  If the user
            gives a valid password he gets full access, but if he
            answers with "guest" he only gets guest access.

        7 - The user is required to enter a valid amateur radio
            callsign, and he is challenged to enter a password, but
            the option to use the password "guest" is available.  If
            the user gives a valid password he gets full access, but
            if he answers with "guest" he only gets guest access.
            This setting is recommended for source addresses which
            aren't either private LAN or 44.x.x.x.

        8 - The specified address [range] is to be treated in the same
            way as a "LAN" address.  Used mainly to prevent HTTP, RHP,
            AGWHOST etc from requiring authorisation when used via a
            VPN.  This flag DOES NOT affect Telnet and FTP logins.

EXAMPLE
        # Subnet[/bits]          flags
        # ==============================
        #
        # HTTP/RHP from this VPN subnet do not require authorisation
          207.221.31.0/8          8
        #
        # Amprnet users need only supply a callsign
          44.0.0.0/8              1
        #
        # LAN users need only supply a callsign
          192.168.0.0/24          1
        #
        # Everyone else must supply callsign and password, but
        # "guest" is allowed as a password, giving read-only access.
          0.0.0.0/0               7


GUEST ACCESS
       Guest access is intented to let people look around, but not
       to do anything that would cause a transmission to be made.

       Guests are prevented from using the SEND, CHAT and CONNECT
       commands, and from sending APRS messages using the APRS
       messaging shell.  For the TELNET command they are restricted
       by the rules in the file TELGUEST.ACL. If that file is not
       present, guests are denied access to the TELNET command.

       Guests are not necessarily unlicenced people. They may simply
       be hams who don't yet have a password for your system.

PASSWORDS
      If passwords are required for user access, they should be
      located in file USERPASS.SYS, which is used for "normal"
      telnet (port 23) logins.

      Do not confuse this with PASSWORD.SYS, which is used for
      sysop logins via AX25, Rlogin and FTP.

SEE ALSO
        PASSWORD.SYS(8) -- Sysop passwords file
        TELGUEST.ACL(8) -- Telnet egress control file
        USERPASS.SYS(8) -- User passwords file

ACCESS.SYS(8)               END OF DOCUMENT
