ACL(1)                  XROUTER REFERENCE MANUAL            23/10/2023

COMMAND
        ACL -- IP Access Control List commands

SYNOPSIS
        AC[l] D[eny] <source> <destination> [protocol]
        AC[l] L[og] [0-3]
        AC[l] M[ove] <rule number> <U[p] | D[own]>
        AC[l] P[ermit] <source> <destination> [protocol]
        AC[l] R[emove] <rule number>
        AC[l] V[iew]
        
DESCRIPTION
        The ACL command allows XRouter's IP Access Control List to
        be viewed and edited on the fly without having to edit and
        reload IPROUTE.SYS.

        The Access Control List specifies which IP addresses are
        allowed to send datagrams to, receive datagrams from, and
        route datagrams through XRouter's TCP/IP stack. It is a
        "packet filter", which operates on "rules".

        A DENY rule denies access to a specified destination from a
        specified source, whilst a PERMIT rule allows access. Both
        types of rule can work on single addresses or whole subnets.

        Rules can be added using the ACL commands, either at the
        command line or in IPROUTE.SYS.

        If the Access Control List contains no rules, the default
        action is "permit", i.e. no filtering is performed. This is
        unsatisfatory, but was necessary to maintain backward
        compatability.

        If one or more rules are present, the default action is
        "deny", i.e. datagrams are ignored unless they match a
        "permit" rule.

        Rules are applied in the order in which they appear in the
        table.

        There is currently no mechanism to save a modified ACL back
        to the IPROUTE.SYS file, as the ACL command is intended only
        for on-the-fly changes.

        The syntax for each sub-command can be revealed by
        typing that sub-command without any arguments.

OPTIONS
        Typing ACL without any arguments reveals the subcommands as
        follows:

            D[eny]      Add a "deny" rule to the TCP/IP filter list 
            P[ermit]    Add a "permit" rule to the TCP/IP filter list
            M[ove]      Moves a rule up or down in the list
            R[emove]    Remove a TCP/IP filter rule
            V[iew]      View TCP/IP filter rules
            L[og]       Display/change ACL logging state

        The PERMIT and DENY sub-commands APPEND filter rules to the
        IP Access Control List.  The <source> and <destination>
        arguments each have the form:

                     <ip_address>[/mask][:port]

        <ip_address> is the source or destination IP address.

        [mask]       is an optional subnet mask, espressed EITHER as
                     the number of bits (0-32) of the IP address to
                     match from left to right, OR as a dotted quad.

        [port]       is an optional TCP or UDP port number. Omitting
                     this or setting it to 0 implies "any port".

        [protocol]   if present, restricts the rule to a single
                     protocol. This is the number of the higher level
                     protocol carried in the IP datagram, for example
                     TCP is 6 and UDP is 17. Omitting this field, or
                     setting it to 0 implies "any protocol".

        The combination 0.0.0.0/32 is a special case matching any of
        XRouter's IP addresses.

        The VIEW subcommand displays all the rules. Each rule has a
        number, which can be used by the REMOVE subcommand.

        The REMOVE subcommand removes a rule. After removal, the
        remaining rules are renumbered.

        The LOG subcommand displays or sets the ACL logging level.
        The only levels so far defined are:

            Level   Actions
            -------------------------------------------
            0       No ACL logging
            1       Log denial events
            2       Display denial events on IDS window
            3       Log and display denial events

        Typing ACL LOG without any arguments displays the current log
        level.

        If ACL logging is enabled, ACL events go into the main daily
        log. Be aware that in some cases this might generate a lot of
        logging, and in other cases virtually nothing. It depends on
        how strict your rules are, what your IP routing table is
        like, how open your system is to the outside world, and how
        much it is attacked.

        Logging defaults off, but the ACL LOG command may be used in
        IPROUTE.SYS to set it on at bootup if desired.

EXAMPLES
        Allow LAN sources to access any destination:

            acl permit  192.168.0.0/16  0.0.0.0/0

        Allow XRouter to access any destination:

            acl permit  0.0.0.0/32  0.0.0.0/0

        Prevent non-LAN sources from accessing our TCP port 513:

            acl deny  0.0.0.0/0  192.168.0.245:513   6

AVAILABILITY
        The ACL command is only available to sysops.

SEE ALSO
        IPROUTE.SYS(8) -- IP Routing File.
        IDS(9)         -- Intrusion Detection System.
        ACCESS.SYS(8)  -- Telnet Access Control File.
        AXSCTRL(9)     -- TCP/IP Access Control.

ACL(1)                      END OF DOCUMENT
