;***********************|****** Max Width *****|*********************|
AD-HOC(9)               XROUTER REFERENCE MANUAL             26/9/2023

NAME
        AD-HOC -- Ad-Hoc Networking.

DESCRIPTION
        "Ad-hoc" networking (AHN) is a variant of AXUDP linking. It
        differs from "normal" AXUDP in that the UDP/IP parameters of
        the link partners are not specified in advance, and instead
        of "one PORT per link", all AHN links share the same PORT.

        As the partners' UDP/IP details are not known in advance, AHN
        is "passive", i.e. like an AXTCP server, it must wait for
        incoming connections. Thus AHN can only be used at ONE end of
        a link.

        Upon receipt of an incoming AXUDP packet, XRouter "remembers"
        its UDP/IP parameters, and uses them to return the replies.

        At present, the UDP/IP parameters are remembered for only ten
        minutes, but as long as the AX25 T3 (link check) time is less
        than that, the link check packets prevent the parameters
        from expiry.

        The "ODN" command currently lists the stored parameters.

        AHN can be used at the same time as "normal" AXUDP, and they
        can both share the same INTERFACE. But there must only be one
        PORT devoted to AHN. If you try to specify more than one AHN
        port, XRouter will refuse to start.

CONFIGURATION
        An AHN PORT requires an AXUDP INTERFACE in XROUTER.CFG, for
        example:

              INTERFACE=9
                   TYPE=AXUDP
                    MTU=256
              ENDINTERFACE

             (Choose the interface number to suit yourself).

        Only TYPE=AXUDP and MTU= are required, all other parameters
        are ignored (at present).

        The minimum configuration for an AHN PORT is as follows:

              PORT=9
                  ID=Ad-Hoc Networking
                  INTERFACENUM=9
                  IPLINK=0.0.0.0
                  UDPLOCAL=10094
                  LEARN=1
              ENDPORT

        IPLINK has no default value. It must be a proper dotted-quad
        IP address i.e."0.0.0.0", not "0". This "special" IP address
        is what tells it to be an Ad Hoc Networking port.

        UDPLOCAL is the UDP "port" number upon which XRouter listens
        for incoming AHN packets. This MUST be different from any
        UDP ports used by "normal" AXUDP. Don't forget to "port
        forward" incoming UDP to this address.

        Note that UDPREMOTE must not be used.

        If there's an ETHERNET port available, XRouter will use its
        own IP stack for AHN, otherwise it will use the Linux stack.

        If you want to "force" the use of the Linux stack, for
        example if the link partner is on the same machine, add the
        following line to the PORT configuration:

            IPADDRESS=127.0.0.1

        Finally, LEARN tells XRouter to remember the IP address and
        udp port of the peer. 

CAVEATS
        AHN allows unplanned and unregulated linking between nodes,
        and is therefore deprecated. Unknown nodes which come and go
        at random can distort the network and cause excessive network
        management traffic. The facility was provided only because
        there was a demand for it. It's just another tool in the
        networking tool box.

        It is assumed that the link partner receives AXUDP on the
        same UDP port as it sends from. If this is not the case, AHN
        will not work, and normal AXUDP must be used.

SEE ALSO
        AXTCP(9)       -- AX25 over TCP.
        AXUDP(9)       -- AX25 over UDP.
        LEARN(7)       -- Learn Unsolicited AX*P Peer Details.
        XROUTER.CFG(8) -- Main Configuration File

AD-HOC(9)                   END OF DOCUMENT
