AGW-IFACE(6)          XROUTER REFERENCE MANUAL                27/9/2023

NAME
        AGW-IFACE -- AGW Packet Engine Interface.

DESCRIPTION
        SV2AGW's Packet Engine (commonly known as AGWPE) is a Windows
        program which manages packet radio hardware and provides AX25
        services to other applications via a TCP/IP API (Application
        Programming Interface).

        The API has been adopted by a number of other systems, some of
        which run on Linux, including Direwolf, and XRouter itself. 

        An AGW interface allows you to use any AGW compatible program
        "underneath" XRouter to manage the hardware, and to provide 
        access to hardware not directly supported by XRouter (e.g.
        sound cards).

        You should not confuse this with XRouter's AGWHOST *emulator*,
        which is provided to support apps which expect to see AGWPE.
        The following diagram attempts to explain the difference:


                  UI-View etc         <-- Application expecting AGW
             .--------------------.
             | (AGWHOST Emulator) |   <-- App interacts with this
             |                    |
             |      XRouter       |
             |                    |
             |  (AGW interface)   |   <-- Interacts with AGWPE
             |--------------------|
             |  AGW Packet Engine |
             '--------------------'
                Soundcards etc.       <-- Hardware supported by AGW

          
        The AGW interface communicates with AGWPE's TCP/IP host
        interface, normally using TCP port 8000. XRouter always uses
        the Linux TCP/IP stack for this connection.

        The AGW Packet engine may be located on the same PC or on a
        different PC, which could be anywhere in the world. Thus you
        could for example have a node in your shack whose RF ports
        are remotely located on a nice hilltop! Or you could remotely
        locate one of your ports to prevent desense etc.

        You may configure more than one AGW interface, provided that
        each copy of AGWPE uses a different IP address/TCP port pair.
        A possible use would be a node which has its RF ports located
        on several different hilltops.


        Configuring the INTERFACE
        ~~~~~~~~~~~~~~~~~~~~~~~~~  
        An AGW interface is specified like this:

            INTERFACE=1              ; Change to suit yourself
                TYPE=AGW
                IOADDR=192.168.0.76  ; AGWPE IP (Default=localhost)
                INTNUM=8001          ; AGWPE TCP port (Default=8000)
                MTU=256
                CONFIG=MyAgwPass     ; Password for AGWPE
            ENDINTERFACE

        Note that IOADDR, INTNUM and CONFIG are all optional, and are
        only needed if you want to change the defaults.

        IOADDR and INTNUM don't have the usual meaning. Instead they
        are used to specify the IP address and TCP port number used
        to communicate with AGWPE.
 
        If you don't specify IOADDR, it defaults to 127.0.0.1, which
        is the same computer as XRouter is on. If AGWPE is on a
        different computer to XRouter, you need to enter its IP
        address here.

        If you don't specify INTNUM, it defaults to 8000, which is the
        default AGW host port. Note that XRouter's AGWHOST emulator
        also defaults to this TCP port, so if you wish to leave AGWPE
        on port 8000 you must disable or reassign AGWPORT in
        XROUTER.CFG.

        If you don't specify CONFIG, XRouter won't "authorise" with
        AGW. Authorisation is not usually required if you're using
        XRouter and AGWPE on the same computer.  You can adjust the
        requirement for authorisation in AGWPE's setup.

        If CONFIG is used, the "username" sent to AGWPE is the
        NODECALL and the "password" is the string specified by CONFIG.


        Configuring the PORTs
        ~~~~~~~~~~~~~~~~~~~~~
        An AGWPE interface can support 16 PORTs, which are declared
        in the usual way, each PORT using a different CHANNEL on the
        INTERFACE - for example:

            PORT=1
                  ID=AGW Port 1
                  INTERFACENUM=1
                  CHANNEL=A
            ENDPORT

            PORT=2
                  ID=Agw Port 2
                  INTERFACENUM=1
                  CHANNEL=B
            ENDPORT


        Configuring AGWPE
        ~~~~~~~~~~~~~~~~~
        - is currently beyond the scope of this page. Please refer to
        the documentation supplied with AGWPE


SEE ALSO
        AGWHOST(6)     -- AGW Hostmode Emulator
        AGWPORT(7)     -- TCP Port for AGW Emulator.
        IFACES(6)      -- Interfaces in XRouter.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

AGW-IFACE(6)              END OF DOCUMENT
