;***********************|****** Max Width *****|*********************|
AGWHOST(6)              XROUTER REFERENCE MANUAL             27/9/2023

NAME
        AGWHOST -- AGW Application Support.

DESCRIPTION
        XRouter provides an AGW TCP host mode interface, allowing apps
        such as UI-View, which would normally use AGW Packet Engine,
        (AGWPE) to use XRouter instead. 

        You should not confuse this with XRouter's AGW *interface*,
        which allows XRouter to interface with "real" AGWPE. The
        following diagram attempts to explain the difference:


                  UI-View etc         <-- Application expecting AGW
             .--------------------.
             | (AGWHOST Emulator) |   <-- App interacts with this
             |                    |
             |      XRouter       |
             |                    |
             |  (AGW interface)   |   <-- Interacts with AGWPE
             |--------------------|
             |  AGW Packet Engine |
             '--------------------'
                Soundcards etc.       <-- Hardware supported by AGW


        There are two ways for an application to interact with AGW
        Packet Engine, one of which is TCP host mode, which normally
        uses TCP port 8000. This is the only mode which XRouter
        emulates.

        Since "real" AGW uses TCP port 8000, XRouter's AGW emulation
        port also defaults to 8000. This can be changed using the
        AGWPORT directive in the GLOBAL section of XROUTER.CFG. You
        might need to do this if you are running AGWPE on the same
        machine. e.g.

            AGWPORT=8001

        Whether or not XRouter requires the applications to send a
        password is controlled by entries in ACCESS.SYS. 

        The following entry allows computers on the LAN to access
        XRouter without a password:

            192.168.0.0/24  1


        AGW host support has so far been tested with:

            - UIView
            - AGWTerminal

        The emulator reports its version number as 2000.15

SEE ALSO
        ACCESS.SYS(8)  -- TCP Access Control File.
        AGW-IFACE(6)   -- AGW Packet Engine Interface.
        AGWPORT(7)     -- TCP Port for AGW Emulator.
        XROUTER.CFG(8) -- Main Configuration File.

AGWHOST(6)                END OF DOCUMENT
