;***********************|****** Max Width *****|*********************|
AGWPORT(7)              XROUTER REFERENCE MANUAL             27/9/2023

NAME
        AGWPORT -- TCP Port for AGW Emulator.

SYNOPSIS
        AGWPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        AGWPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        by the AGW emulator. If not present, the default is 8000.

        The AGW emulator enables suitable AGW clients, such as
        UI-View, to use XRouter instead of AGW Packet Engine.

OPTIONS
        If a single argument is supplied, e.g. "AGWPORT=8000", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "AGWPORT=8000 9000", the
        first argument applies to the XRouter stack and the second to
        the host system's stack. The numbers must be separated by
        whitespace

        Setting AGWPORT to zero on a stack prevents TCP connections
        to the AGW emulator via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        AGWHOST(6)     -- AGW Emulator.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

AGWPORT(7)           END OF DOCUMENT
