AMSG(1)                 XROUTER REFERENCE MANUAL            19/10/2023

COMMAND
        AMSG -- Enter APRS Messaging mode.

SYNOPSIS
        AM[sg] <portnum>

DESCRIPTION
        The AMSG command switches the user's session into APRS 
        messaging mode, enabling him to exchange messages and 
        bulletins with APRS and UI-View users.

        The <portnum> argument specifies the radio port upon which 
        traffic will be sent and received. e.g. "AM 13" will use port 
        13.

        Within messaging mode, all commands begin with a forward
        slash (/), and anything else is treated as message text for 
        transmission.  The commands are as follows:

            /A[nnouncements]    Show announcements
            /B[ulletins]        Show bulletins
            /C[ancel] [#]       List / cancel unacked message(s)
            /D[irects]          Show directly heard stations
            /H[elp] [cmd]       Display command help
            /Monitor [on|off]   Query / set traffic Monitor mode
            /Q[uit]             Quit (exit)
            /T[arget] [call]    Query / set target for msg
            /U[iview] [on|off]  Query / set UI-View mode
            /V[ia] [digis]      Query / set digipeater path
            /X                  Exit

        Only the first letter of each command needs to be supplied.
        A few are worthy of further explanation....

        The /D command shows a list of all the stations heard 
        directly, i.e. not via digipeaters or 3rd party networks.

        Before any type of message or query can be sent, the user
        must specify a "target" address, using "/T [call]".  For
        messages, the target is a callsign.  For bulletins the target 
        should be BLN#*, where "#" represents a single digit, and "*" 
        represents the bulletin category of up to 5 characters.  
        Announcements use the same format as bulletins, except that 
        "#" represents a non-digit.  Attempting to send a message 
        without first defining a target will result in an error 
        response.  The target remains in force until a new target is 
        specified.  The current target can be displayed by entering 
        "/T" alone, or cleared by entering an invalid target, e.g.
        "/T .".

        Outgoing messages and bulletins are re-transmitted at 
        intervals until either an acknowledgement is received, or too 
        many retries have taken place.  Bulletins are re-transmitted 
        every 20 minutes for 4 hours, whilst announcements are re-
        transmitted every hour for 4 days. Messages are initially re-
        transmitted after 10 seconds, then the interval doubles with 
        each re-send.  When the interval exceeds approximately 1.5 
        hours, the message is expired and re-transmission ceases.
        The "cancel" command allows the re-transmission of outgoing 
        messages and bulletins to be cancelled at any time before 
        expiry.

        The /M (Monitor) command allows other APRS and UI-View
        message traffic on the channel to be watched.  The default
        is "off".  Entering /M by itself shows the current state.

        The /U (Ui-View mode) command sets the type of outgoing 
        message to be used.  The default is "off", which means that 
        all outgoing messages will be in APRS format. If turned "on", 
        outgoing messages will be in "UI-View" format.  In either 
        mode, both types of message can be received. UI-View messages 
        will display with a tilde (~) between the message and its ID, 
        whereas APRS-format messages will display with a curly
        opening bracket ({) if a message ID was supplied.  In UI-View
        mode, "\<decimal>" will send a UIVIEW message whose text
        portion  contains a single byte of value <decimal>, e.g.
        "\254" sends a PING request.

        /Q (quit) and /X (exit) are identical in function, exiting 
        message mode and returning the user to XRouter's main command
        prompt.

        The /V (via) command sets the digipeater path for outgoing 
        messages, or if used by itself displays the currently set 
        path.  The path defaults to the port APRSPATH specified in 
        XROUTER.CFG.  In APRS mode, the destination call is fixed at 
        APZ###, where ### is the 3 digit Xrouter version number, 
        whereas in UI-View mode the destination call is set by the 
        /Target command.

        The /H (help) command is used to display help for the 
        messaging commands.  If no argument is supplied, a very brief 
        (low bandwidth) command resume is displayed.  If the help 
        files are installed, "/H *" will list the help available, and 
        "/H <cmd>" can be used to obtain more detailed help for
        <cmd>, e.g. "/H /V". Note that the leading slash of the
        argument is ignored, so "/H V" is equally valid.

NOTES
        If Xrouter receives an APRS message whose target address is a 
        user currently logged into the APRS messaging shell, the 
        message is delivered to the user and, if there was a message 
        ID, an acknowledgement is sent.  Each re-send of the message 
        is acknowledged, because a re-send probably indicates that
        the sender didn't receive the previous ack.

        If the same message is received twice within 30 seconds, the 
        second copy is ignored.  This helps to eliminate duplicates 
        received via different digipeater routes.

        Expired messages are retained for 1 day before being deleted.  
        During this interval they will be reactivated if a "?APRSM" 
        query is received from the target station.  Outgoing
        bulletins and announcements are not retained after expiry.
        Incoming  bulletins are retained for 4 hours after last
        received, and incoming announcements are retained for 4 days
        after last received.

        The APRS spec limits the maximum message length to 67 
        characters. Because a message ID of up to 6 characters is 
        appended to the message, XRouter splits messages longer than 
        61 characters into separate messages no longer than 61 
        characters (excluding ID) each.

        All APRS facilities are an ongoing experiment and may be 
        liable to change as development continues.  The so-called 
        "APRS Protocol Reference" is rather fuzzy in places!

AVAILABILITY
        All users, but guests can't send messages.

AMSG(1)                     END OF DOCUMENT
