APPLMASK(1)             XROUTER REFERENCE MANUAL               4/9/2023

COMMAND
        APPLMASK -- Display / Set Application Connectivity Mask.

SYNOPSIS
        APP[lmask] <port> [0-255]

DESCRIPTION
        The APPLMASK command displays and controls which applications
        are connectable at AX25 L2 on the specified port. It has a
        similar function to the APPLMASK directive, used in
        XROUTER.CFG, but facilitiates runtime changes.

        In this context, "applications" refers to programs which use
        XRouter to provide their connectivity with the outside world. 

        In order to be directly connectable on a particular port,
        the application must have an APPLCALL, an APPLALIAS or both,
        and the corresponding bit in that port's APPLMASK must be set.

        APPLMASK specifies which applications are directly
        connectable on a given port.  The default is 255, which allows
        all applications.  The value is made up by adding together the
        desired selection from the following numbers:

                      1       - Enable Application 1
                      2       - Enable Application 2
                      4       - Enable Application 3
                      8       - Enable Application 4
                      16      - Enable Application 5
                      32      - Enable Application 6
                      64      - Enable Application 7
                      128     - Enable Application 8

        For example, if a port's definition contains "APPLMASK=9", it
        will only allow direct connections to applications 1 and 4 on
        that port, providing those applications have either an
        APPLCALL or an APPLALIAS.

AVAILABILITY
        The APPLMASK command is only available to sysops.

SEE ALSO
        APPLMASK(7)    -- APPLMASK Directive
        APPLS(9)       -- Application Support.
        XROUTER.CFG(8) -- Main Configuration File.
        
APPLMASK(1)                 END OF DOCUMENT
