APPLS(9)                XROUTER REFERENCE MANUAL            19/10/2023

NAME
        APPLS -- Application Support.

DESCRIPTION
        In this context, "applications" refers to programs which use
        XRouter to provide their connectivity with the outside world. 

        Unlike its 16 bit forerunner, XRouter does not provide the
        BPQ Host API, but it does provide the following means for
        supporting applications: 

            - AGW TCPHOST Interface 
            - WA8DED Hostmode Emulation 
            - TNC2 Emulation 
            - KISS / SLIP / PPP
            - Remote Host Protocol (RHP) 
            - Proxies
            - TCP applications (e.g. QtTermTcp)


        Defining Applications
        ~~~~~~~~~~~~~~~~~~~~~

        Some applications, such as those using the TNC2 emulator, do
        not accept incoming connections, and this section doesn't
        apply to them.  Nor does it apply to applications accessed
        via KISS / SLIP / PPP or proxies.  For the remainder,
        read on...

        In order for applications to be able to accept incoming
        connections, they must be specified in XROUTER.CFG, using
        APPL configuration blocks.

        Each definition block must begin with APPL=<number> and must
        end with ENDAPPL.  There must be a separate block for each
        application.  Applications which use more than one stream
        need only a single definition.  The APPL block should contain
        one or more of the following keywords:

        APPLNAME  The nickname or shortcut by which the application
                  is accessed from XRouter's command line. e.g.
                  "PMS".  If a user types this name at the command
                  prompt, they will be connected to the application.

        APPLCALL  The AX25 layer 2 callsign which the application
                  will use. If specified, the application will accept
                  AX25 L2 connects to this callsign, subject to the
                  setting of APPLMASK (see below).

        APPLALIAS The AX25 layer 2 "alias" used by the application.
                  If specified, the application will accept AX25 L2
                  connects to this callsign, subject to the setting
                  of APPLMASK (see below). 

        APPLQUAL  Netrom quality to broadcast (0-255).  If a non-zero
                  value is specified here, the APPLCALL will be
                  included in Net/Rom nodes broadcasts and the
                  application will be connectible at AX25 layer 4.
                  The higher the quality, the further the node entry
                  will propogate. 

        APPLFLAGS defaults to 0 if omitted. The flags are as follows:

                Bit Value  Action
                ------------------
                 0    1    Application has SYSOP privileges.

                 1    2    Allow "guest" users to access the appl.

                 2    4    XRouter sends "Connected to (applcall)"
                           to the user upon connection to an
                           application.  This is not required if the
                           application  sends its own "Connected to"
                           message.

                 3    8    XRouter sends "Connected to (usercall) to
                           the application when a user connects. 

        APPLTYPE is only required for TCP applications at present.
                 The format is APPLTYPE=TCP,[ip_addr:]tcp_port
                 (ip_addr is only required if the application is on
                 a different computer)

        Most fields within an application definition block are
        optional - you may have for instance choose to have an
        APPLNAME but no APPLCALL, meaning the application could only
        be reached by typing the applname at the command prompt.

        Or you could have an APPLCALL but no APPLNAME, in which case
        the application would be directly connectable, but wouldn't
        be reachable from a command line shortcut. 
 
        The application number must be between 1 and 8.  Some BPQHOST
        applications have fixed application numbers, e.g. BBS's and
        PMS's must usually be the first application and Host programs
        such as PAC4 are usually the second.  However, since BPQHOST
        API isn't currently implemented, the choice of application
        number is arbitrary at present.

        Example for a Bulletin Board System application using WA8DED
        hostmode.  It is accessed by typing "BBS" at the command
        prompt or by connecting via AX25 or NetRom to the callsign
        GB7PZT or the alias PZTBBS:

                APPL=3
                        APPLNAME=BBS
                        APPLCALL=GB7PZT
                        APPLALIAS=PZTBBS
                        APPLQUAL=100
                        APPLFLAGS=4
                ENDAPPL

        In the following example, the application has no callsigns or
        quality, so it can only be reached by issuing the command
        "HOST" at the command prompt:

                APPL=2
                        APPLNAME=HOST
                ENDAPPL

        Example for incoming connections to a TCP application such as
        QTTERMTCP. It can be acessed by an AX25L2 connection to G9ZZZ
        or by typing "SYSOP" at the command prompt. QtTermTCP is set
        up to listen on TCP port 8015:

                APPL=1
                        APPLNAME=SYSOP
                        APPLTYPE=TCP,8015
                        APPLCALL=G9ZZZ
                ENDAPPL


        AX25 Visibility
        ~~~~~~~~~~~~~~~

        If you want an application to be directly connectible on a
        particular port, the application must have an APPLCALL, an
        APPLALIAS or both, and the corresponding bit in that port's
        APPLMASK must be set.

        APPLMASK specifies which applications will be directly
        connectible on a given port.  The default is 255, which
        allows all applications.  The value is made up by adding
        together the desired selection from the following numbers:

                      1       - Enable Application 1
                      2       - Enable Application 2
                      4       - Enable Application 3
                      8       - Enable Application 4
                      16      - Enable Application 5
                      32      - Enable Application 6
                      64      - Enable Application 7
                      128     - Enable Application 8

        For example, if a port's definition contains "APPLMASK=9", it
        will only allow direct connections to applications 1 and 4 on
        that port, providing those applications have either an
        APPLCALL or an APPLALIAS.


        Downlinking From Applications
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Certain settings of a port's CFLAGS may prevent all
        downlinking on that port.  For example, in a mixed CB/HAM
        node you may need to use CFLAGS=1 to prevent CB users from
        making L2 downlinks on the HAM port.  But that would also
        prevent HAM applications from downlinking on that port.

        This can be solved by setting bit 2 (decimal value 4) of
        CFLAGS, which allows applications to downlink
        unconditionally.

        Setting this flag allows applications to make L2 downlinks on
        ports which are closed to users, e.g. CFLAGS=1 prevents
        everyone excepts sysops from downlinking, whereas CFLAGS=5
        prevents everyon except sysops and applications from
        downlinking. See CFLAGS for more details.

SEE ALSO
        AGWHOST(6)     -- AGW Application Support.
        CFLAGS(7)      -- Connection Control Flags.
        DEDHOST(9)     -- WA8DED Hostmode Emulator.
        RHP(9)         -- Remote Host Protocol.
        TNC2(9)        -- TNC2 Emulator.
        XROUTER.CFG(8) -- Main Configuration File.
        
APPLS(9)                    END OF DOCUMENT
