APRS-SRV(9)             XROUTER REFERENCE MANUAL            21/10/2023

NAME
        APRS-SRV -- APRS Server.

DESCRIPTION

        XRouter includes a rudimentary APRS server, which enables
        suitable APRS clients, such as UI-View, to connect to it on
        the LAN and exchange APRS traffic.  The number of concurrent
        clients is not limited.

        The server is available via NetRomX service 14, and TCP/IP.


        TCP Port Number
        ~~~~~~~~~~~~~~~

        The server listens for incoming connections on TCP port 1448.
 
        There is a tradition of choosing port numbers for APRS
        servers which represent the frequencies used by APRS, hence
        port 1448 was chosen because XRouter originates in the UK,
        and many European countries use 144.800 MHz.

        Overview Of Server
        ~~~~~~~~~~~~~~~~~~

        The following APRS packets are sent to clients:

           - APRS traffic received by any of XRouter's radio ports.

           - Traffic sent by other clients.

           - Traffic sent by users of XRouter's APRS messaging shell.

           - Filtered traffic from Internet APRS servers (if
             XRouter's IGATE is connected to an Internet APRS server)


        APRS packets from clients are distributed as follows:

           - To other clients, excluding the sender.

           - To XRouter's APRS messaging shell.

           - To radio ports (only if client is fully registered)

           - To Internet APRS servers via IGATE (if IGATE enabled).


        Registration and Login
        ~~~~~~~~~~~~~~~~~~~~~~

        Registration of clients is necessary to prevent unauthorised
        use of radio frequencies by unlicensed people.

        This may seem overly restrictive if your system is only used
        on a private LAN, but if you are connected to the Internet,
        it is essential.

        For example, if an unlicensed user connects to your server
        via the Internet, he must be prevented from sending traffic
        to your local RF ports.  He must also be prevented from
        sending traffic via your IGATE (if it is enabled) into the
        Internet system, and thence to other people's RF ports.

        Therefore, clients are required to complete a log-in process
        before they are allowed to send any traffic.  Log-in is not
        required for receive-only operations.

        The server accepts two different types of login.  When a
        user registers an APRS client program such as UI-View, he
        receives a "validation number" which XRouter uses in
        combination with the callsign to verify the user. Verified
        users may send traffic to local RF ports, or if IGATE is
        active, via other IGATES.

        If the user has NOT registered his copy of UI-View, the
        default validation number of "-1" allows him to send traffic
        to other clients and to the Internet, but that traffic will
        not be gated locally to RF, and is marked in such a way that
        it will not be gated to RF by other IGATES. This allows
        unregistered clients to communicate with each other via the
        Internet, but not via RF.  The client may only send APRS
        packets whose source callsign matches the login callsign.

        The alternative login system allows clients to verify
        themselves by supplying their callsign and a password which
        has been agreed with the sysop.  The password replaces the
        validation number in a login string.

        The login string is the only "command" accepted by the APRS
        server, and must take the form:

             "user <callsign> pass <password>"

        where <password> could be either a validation number or a
        text string, for example, "user g8pzt pass beanzmeanzheinz",
        or "user g7zzz pass 32751". Login is not acknowledged.


        The Client Connection
        ~~~~~~~~~~~~~~~~~~~~~

        There is no time-out on client connections, therefore there
        is no need for the client to send "keep-alive" signals.

        If the client connection is too slow to cope with the
        incoming data rate, packets to the client may be discarded.


        Local <> Internet Server Gating
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        If IGATE is not running, no packets are gated to or from the
        Internet.

        Packets received from the Internet are not gated to clients
        unless they satisfy the IFILTER (Internet Filter) filtering
        rules in IGATE.CFG.  Likewise, packets received from clients
        are not gated to the Internet unless they satisfy the
        PFILTER (Packet Filter) rules.

        The following traffic is NOT gated from RF to Internet

           - Packets in "third party" format.

           - Packets which do not include the network identifier
             "TCPIP" in the digi path.

           - Packets which include the dummy callsigns NOGATE or
             RFONLY in the digi path.


        Using UI-View as a Client
        ~~~~~~~~~~~~~~~~~~~~~~~~~

        Select Setup/APRS Server Setup.

        In the box marked "Select A Server", enter the hostname and
        TCP port number of XRouter's APRS server, e.g.
        "myserver:1448" or "192.168.0.2:1448".  If the client is on
        the same computer as  XRouter, use "localhost:1448" or
        "127.0.0.1:1448". (If you use a private hostname, you may
        need to add a suitable entry into the HOSTS file in the
        WINDOWS directory, or Linux equivalent.)

        Check the boxes marked "Open the gateway" and "Gate local
        messages".

        If you have a registered version of UI-View, check the box
        marked "APRServe log on required", and enter your validation
        number.

        If your copy of UI-View is unregistered, you will be able to
        log on to XRouter's APRS server with the default validation
        number of -1, but your packets will not be gated to RF.

        To obtain full privileges using an unregistered copy, you
        must have a password, which must be registered with your
        callsign in XRouter's USERPASS.SYS file.  The callsign must
        not include the SSID, e.g. if UI-View's callsign is
        "G8PZT-11", the entry in USERPASS.SYS should simply be
        "G8PZT".  Un-check the "APRServe log on required" box, and
        in the box marked "Text to send upon connection" enter
        UI-View's callsign (with SSID) and your password in the
        following form:

              user g8pzt-11 pass virago


SEE ALSO
        APRS(9)         -- APRS in XRouter.
        APRS-SVC(9)     -- NetRomX APRS Service.
        APRSPORT(7)     -- TCP Port for APRS Server.
        IGATE(9)        -- APRS-Internet Gateway.
        IGATE.CFG(8)    -- Igate Configuration File.
        TCP-PORTS(6)    -- TCP Service Ports.
        USERPASS.SYS(8) -- User Passwords File.
        XROUTER.CFG(8)  -- Main Configuration File.

APRS-SRV(9)                 END OF DOCUMENT
