APRS(9)                 XROUTER REFERENCE MANUAL            21/10/2023

NAME
        APRS -- Automatic Packet Reporting System.

DESCRIPTION
        APRS is (currently) an acronym for "Automatic Packet
        Reporting System", although the name tends to change from
        time to time! (it was originally called "Automatic *Position*
        Reporting System, and there has been talk of re-branding it
        to Automatic PRESENCE Reporting System).

        It is a protocol that uses AX25 UI frames and digipeaters to
        report a wide variety of parameters such as position, speed,
        weather, bearing, status, objects, frequencies and so on.

        XRouter includes the following sub-systems that support or
        make use of APRS:

                - APRS Generic Digipeating
                - APRS Igate
                - APRS Server
                - APRS Messaging Shell
                - APRS Weather reports
                - APRS DX recording
                - APRS Queries
                - Positions, distances & directions in MH lists

        Generic digipeating is a complex type of digipeating which
        responds to special digipeater addresses, and modifies a
        packet's digipeater addresses in transit. It also prevents
        duplicates and looping.

        The Igate is a client daemon that allows APRS data to flow to
        and from between the Internet APRS system and RF ports,
        messaging shell etc.

        The APRS server allows APRS applications such as UI-view to
        use XRouter to access all the APRS data handled by XRouter.

        The APRS messaging shell allows users to send and receive
        APRS messages and bulletins.

        Weather reports are received via RF and/or Igate, and are
        made available for users to read using the WX command.

        The DX feature stores a list of the furthest stations heard
        via RF.

        APRS Queries allow RF users to query which nodes are on
        channel, what DX they heard, what messages are waiting etc.

        MHeard lists are able to display the positions, bearings and
        distances of stations that broadcast APRS data.


        Specifying XRouter's Position
        ~~~~~~~~~~~~~~~~~~~~~~~~~~

        In order for most of these systems to work, XRouter needs to
        know its position on the globe. There are currently three
        ways to achieve this...

        The easiest method is to use the "LOCATOR=" directive in
        XROUTER.CFG, which enables you to specify an approximate
        location at the centre of a 1Km "Maidenhead" locator square,
        e.g. "LOCATOR=IO82VJ".

        If you don't know your LOCATOR square, an alternative method
        is to use lATITUDE and LONGITUDE directives in XROUTER.CFG.
        These are specified in decimal degrees, which can easily be
        found from Google Maps. East and North are positive numbers,
        while South and West are specified as negative numbers. You
        should not append N S E or W.

        Another method, which allows more precise (or less precise
        if you prefer) positioning, is to include an APRS-style
        position in IDTEXT, starting within the first 40 characters.

        The format is "!ddmm.mmN/dddmm.mmE#" where dd represents
        degrees of latitude/longitude and mm.mm represents minutes
        to two decimal places. "N" and "E" may be replaced by "S"
        and "W" as appropriate. For example:

              IDTEXT
              !5224.00N/00215.00W# Kidderminster Router (KDRMIN)
              ***

        You are urged to use at least one of these methods to define
        XRouter's position. It really does make Packet more
        interesting!


        APRS Generic Digipeating
        ~~~~~~~~~~~~~~~~~~~~~~~~

        XRouter supports APRS generic digipeating for RELAY, WIDE,
        TRACE, TRACEn-N and WIDEn-N aliases.

        Generic digipeating is configured on a port by port basis,
        using the flags marked "*" in "DIGIFLAG" as follows:

              1    Digipeat UI frames (note 1)
              2    Digipeat non-UI frames (note 1)
             *4    Enable RELAY generic digipeating.
             *8    Enable TRACE generic digipeating.
             *16   Enable WIDE (Well sited stations only!)
             *32   Allow APRS 3rd party digi via L4.
             *64   Allow digipeating to Internet (IGate).
             *128  Allow digipeating from Internet (IGate).
             *256  Enable UITRACE digipeating
             *512  Enable UIFLOOD digipeating

             Add the appropriate numbers together to enable the
             desired combination of services.

        Note 1: Irrespective of the generic digipeater settings, you
        may choose to allow regular digipeating (i.e. using XRouter's
        normal callsign or alias) on APRS ports, allow regular
        UI-only digipeating, or disable regular digipeating
        altogether, by manipulating bits 0 and 1 of DIGIFLAG.


        SSID Substitution Digipeating
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        UITRACE and UIFLOOD represent two special addresses that are
        suffixed with pseudo-SSID's, e.g. "TRACE4-4" and "WIDE2-2".

        These addresses can digipeat several times. The first digit
        specifies the maximum number of hops, and the second is the
        hop counter, which is decremented each time the frame is
        digipeated.

        These two addresses behave slightly differently however. When
        a frame is digipeated on the alias specified by UITRACE, each
        digipeater inserts its own callsign in the digipeater list,
        and decrements the "SSID". Frames digipeated on the UIFLOOD
        address have their SSIDs decremented, but the digi doesn't
        insert its own callsign. 

        For the sake of consistency with UI-View, UITRACE defaults to
        "TRACE", giving TRACEn-n digipeating, and UIFLOOD defaults to
        WIDE, giving WIDEn-n digipeating.


        New-N Paradigm
        ~~~~~~~~~~~~~~

        According to the APRS "New-N Paradigm", RELAY, TRACE and WIDE
        are deprecated, UITRACE should be set to "WIDE", and UIFLOOD
        should be set to a "state" code (e.g. "GBR" for the UK).

        One of the main reasons for the New-N Paradigm was the fact
        that some of the older digipeaters would digipeat the same
        packets over and over. This does not happen with XRouter.

        Not everyone agrees with the "New-N Paradigm, so the choice
        of which features to enable is left you you.


        Mixing Modes
        ~~~~~~~~~~~~

        In quiet areas, you may wish to mix APRS and normal
        connected-mode operations on the same port, and that is the
        default if you enable any of the above flags in DIGIFLAG.

        However, in most areas, APRS tends to be on a separate
        frequency reserved for "unconnected nets", and you may wish
        to prevent people from connecting to the node or downlinking
        from it on your APRS-only ports.

        The CFLAGS keyword can be used in the PORT section of the
        XROUTER.CFG file to control uplinking and downlinking as
        follows:

               0     Prevent uplinking and downlinking.
               1     allow uplinking only.
               2     allow downlinking only.
               3     allow both up and downlinking.


        ID Beacons
        ~~~~~~~~~~

        Whilst all sysops are urged to include an APRS position in
        their normal IDTEXT, a dedicated APRS port may require a more
        detailed and cryptic  ID beacon, therefore you may define a
        different IDTEXT for each port if necessary.

        A "regular" port would include a position followed by some
        human-readable text, whereas the APRS-only ports would
        include additional data such as power / height / gain /
        direction,  wind speed, bowel movements etc., in encoded
        format.

        The IDTEXT may be sent via digipeaters by including the
        IDPATH keyword in the relevant port configuration section of
        XROUTER.CFG.


        Dupe Suppression
        ~~~~~~~~~~~~~~~~

        XRouter checks for its own callsign or alias in previously
        used digipeaters to prevent digi looping.  It will not
        digipeat frames it originated, and will not digipeat the
        same frame within 9 seconds.


        DX Facility
        ~~~~~~~~~~~

        The "DX [port]" command shows the best received APRS DX. It
        only works if XRouter's position has been defined as
        described earlier.

        The DXFLAGS keyword in the .CFG file controls whether or not
        the DX list contains callsigns heard via digipeaters.

        The DX list may be queried by RF stations, by means of APRS
        queries.


        APRS / UI-View queries
        ~~~~~~~~~~~~~~~~~~~~~~

        XRouter responds to the following general queries:

            ?APRS?   All stations query. 

            ~\xFD~   UI-View general query.

            ?IGATE?  Igate query.

        The response to the first two is the ID beacon for the port,
        which should contain the APRS position and station type.  The
        response to the ?IGATE? query shows the message and local
        user counts.

        The following "directed" queries (directed at portcall) are
        supported:

            ?APRSD   Directly heard stations list.
                     Responds with a list of stations heard directly
                     on the receiving port (i.e. not via digipeaters
                     or via 3rd party networks)

            ?APRSM   Un-delivered messages query.
                     If there are any un-delivered or expired
                     messages addressed to the sender of the query,
                     they are re-activated and transmitted on the
                     port which received the query.

            ?APRSP   Station Position.
                     If the sysop has defined XRouter's position, it
                     is sent in response to this query.

            ?APRSS   Station status.
                     The response consists of the software type and
                     version plus a list of the enabled generic
                     digipeater calls.

            ?PING?
            ?APRST   Trace Route.
                     Both of these return the route by which the
                     query was received.

            ~\xFE~n  UI-View "ping".
                     The response to this query is a UI-View ack for
                     the ping id.

            ~\FC~n   UI-View "DX" query.
                     Responds with a UI-View ack, followed by details
                     of the best DX heard directly by XRouter
                     (digipeated packets are NOT included!)

        See www.aprs.org for more info about APRS.

SEE ALSO
        AMSG(1)        -- APRS Messaging Mode.
        APRS-SRV(9)    -- APRS Server.
        APRS-SVC(9)    -- NetRomX APRS Service.
        DX(1)          -- Display Distant APRS stations.
        IGATE(9)       -- APRS Igate.
        MHEARD(1)      -- Display Recently Heard Stations.
        MHEARD(9)      -- About the MHeard Facility.
        WX(1)          -- Display APRS Weather Information.
        XROUTER.CFG(8) -- Main Configuration File.

APRS(9)                     END OF DOCUMENT
