APRSPORT(7)             XROUTER REFERENCE MANUAL             27/9/2023

NAME
        APRSPORT -- TCP Port for APRS Server.

SYNOPSIS
        APRSPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        APRSPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        by the APRS server. If not present, the default is 1448.

        The APRS server, enables suitable APRS clients, such as
        UI-View, to connect to it on the LAN and exchange APRS
        traffic with each other, with RF and via the IGATE.

OPTIONS
        If a single argument is supplied, e.g. "APRSPORT=1234", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "APRSPORT=1234 5678", the
        first argument applies to the XRouter stack and the second to
        the host system's stack. The numbers must be separated by
        whitespace

        Setting APRSPORT to zero on a stack prevents TCP connections
        to the server via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

        The APRS server is also available as NetRomX service 14.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        APRS-SRV(9)    -- APRS server.
        APRS-SVC(9)    -- NetRomX APRS Service.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

APRSPORT(7)           END OF DOCUMENT
