ARP(9)                  XROUTER REFERENCE MANUAL            21/10/2023

NAME
        ARP -- Address Resolution Protocol

DESCRIPTION
        The Address Resolution Protocol handles the association
        between IP addresses and "hardware" (Ethernet or AX25)
        addresses.

        In order for IP datagrams to be handled by AX25 or Ethernet
        links, they must first be "wrapped" in AX25 or Ethernet
        packets.

        The destination addresses of these packets is determined by
        the process of "Address Resolution".

        For example, imagine that you want to send an IP datagram to
        one of your neighbour nodes via RF.  TNC's don't understand
        IP, so you can't simply transmit a raw IP datagram onto the
        airwaves.  Your node must first "wrap" the datagram in an
        AX25 frame addressed to the neighbour node.  Upon receipt by
        the neighbour, the frame is "unwrapped", and the IP datagram
        contained therein is handled by the IP router.

        Exactly the same process is required to send IP over
        Ethernet, except that Ethernet frames are used instead.

        The destination address is usually obtained from an "ARP
        Table", that stores each neighbour's IP addresses along with
        their AX25 or Ethernet address.  This table can be built
        manually using ARP commands, or dynamically.  A typical ARP
        table would contain entries similar to this:

           IP Address      Type    Hardware addr
           ------------------------------------------
           44.131.91.2     AX25    G8PZT
           44.131.90.6     AX25    G8JVM-5
           192.168.0.23    Ether   00:12:34:66:21:DA

        If the destination address is not in the ARP table, XRouter
        broadcasts an "ARP request" packet, asking if anyone knows
        the hardware address associated with the destination IP
        address.  The destination node replies with an "ARP reply",
        giving the AX25  address that the datagram should be
        addressed to.  XRouter adds this data to the ARP table, then
        uses it to wrap and send the datagram.

        The "ARP entries" in the table usally have a finite lifetime
        (usually 15 minutes), because neighbours sometimes change
        their hardware addresses.  This lifetime may be altered by
        the sysop.

        When an entry gets too old, it is purged from the table,
        forcing XRouter to send another ARP request, thus picking up
        the new hardware address. The sysop may override this by
        "locking-in" ARP entries.

        A router other than the destination may reply to an ARP
        request if it is the gateway to a "hidden" network containing
        the destination. This is called "proxy ARP", is implemented
        in XRouter and is detailed in RFC1027.

        The ARP protocol is detailed in RFC826.
 
SEE ALSO:
        ARP(1) -- ARP Commands. 

ARP(9)                      END OF DOCUMENT
