ARP(1)                  XROUTER REFERENCE MANUAL            21/10/2023

COMMAND
        ARP -- Display / Edit the ARP table.

SYNOPSIS
        ARP A[dd] <host> <hwtype> <addr>
        ARP C[md] [0-255]
        ARP D[rop] <host> <hwtype>
        ARP F[lush]
        ARP L[ist]
        ARP M[axq] [0-32767]
        ARP LE[arn] <port | default> [ON | OFF]
        ARP P[ublish] <host> <hwtype> <addr>
        ARP T[imeout] [secs]
        ARP W[ait] [secs] 

DESCRIPTION
        The ARP command is used to display and edit the Address 
        Resolution Table, which maps IP addresses to hardware ones.

        <host>   is an IP address in dotted quad form.
        <hwtype> is hardware type, i.e. "ax25" "netrom" or "ether".
        <addr>   is the hardware address (callsign / ethernet addr).

        ARP by itself, lists the table.
        ARP ADD is used to add an entry to the table.
        ARP CMD specifies the functionality of the ARP command.
        ARP DROP is used to delete an entry from the table.
        ARP FLUSH flushes temporary entries from the table.
        ARP LEARN controls arp learning.
        ARP LIST lists the table.
        ARP MAXQ limits no. of datagrams queued pending resolution.
        ARP PUBLISH adds an ARP proxy entry for a hidden system.
        ARP TIMEOUT specifies max life of a dynamic entry (secs).
        ARP WAIT specifies how many secs to wait for an ARP reply.

EXAMPLES
        ARP ADD 44.131.91.2 ax25 gb7pzt-5    Add ax25 entry
        ARP DROP 44.131.91.7 ax25            Delete ax25 entry
        ARP PUB 44.131.91.127 ax25 g8pzt     Publish 91.127
        ARP TIMEOUT 30                       Set 30 sec lifetime
        ARP LEARN 2 ON                       Enable learn on port 2
        ARP LIST                             List the table
        ARP                                  List the table

MORE INFO
        ARP PUBLISH is used when a host is "hidden" on a network
        which is only accessible via XRouter, and allows XRouter to
        respond to ARP requests for the hidden system, by returning
        its own hardware address.

        The argument for "ARP CMD" is the sum of the desired options
        from the following list::

             1 = Command is available to secure sysops
             2 = Command is available to non-secure sysops
             4 = Command is available to users
             8 = Private addresses visible to secure sysops
            16 = Private addresses visible to non-secure sysops
            32 = Private addresses visible to all users

        The default is 9 (secure sysops only).
        A "secure sysop" is at the console, or on a private LAN.
        A "non-secure sysop" is one using a public RF network.

        ARP LEARN controls whether or not XRouter "learns" ARP info
        from passing ARP traffic. The default is for learning to be
        ON, but it may be enabled/disabled using
        ARP LEARN DEFAULT [on | off].

        Regardless of the default setting, learning can be enabled or
        disabled for any port, using ARP LEARN <portnum> [on | off].
        if not refreshed, learned entries persist for the interval
        specified by TIMEOUT, usually 15 minutes.

        ARP FLUSH removes temporary entries, i.e. those pending
        resolution. The default lifetime for these entries is
        specified by ARP WAIT (default 30 secs).

        ARP MAXQ [0-32767] is used to limit the nunber of datagrams
        which may be queued pending resolution. The default is 100.
        If the address fails to resolve, the queued datagrams are
        dropped.
        
AVAILABILITY
        The availability of the command is controlled by "ARP CMD",
        which is detailed above.

FILES
        ARP commands to be executed at boot-up are usually placed in
        IPROUTE.SYS, but they may also be used in BOOTCMDS.SYS.

NOTES
        In order for this command to have any meaning, XRouter must 
        have an IP address and be connected to an IP-capable network.

        You cannot add hardware address types for which there is no
        compatible interface, e.g. an attempt to add an Ethernet
        address on a system with no Ethernet interfaces will fail.

        The defaults are as follows:
        TIMEOUT=900 secs. WAIT=30 secs, MAXQ-100, CMD=9

SEE ALSO
        ARP(9) -- Address Resolution Protocol

ARP(1)                      END OF DOCUMENT
