ASYNC-IFACE(6)        XROUTER REFERENCE MANUAL                23/9/2023

NAME
        ASYNC -- Interface Type "ASYNC"
 
DESCRIPTION
        The ASYNC interface type specifies an asynchronous character
        by character interface, such as RS232 or a pseudo-TTY.

        It is so-called because individual characters are sent and
        received asynchronously, either singly or in random sized
        bunches, rather than in synchronism with a clock signal.

        In XRouter this usually means USB-to-Serial adaptors which
        appear as /dev/ttyUSB0 etc.

        A typical ASYNC interface would be defined thus:

        INTERFACE=1
                TYPE=ASYNC
                ID=Multidrop KISS TNCs
                COM=/dev/ttyUSB1
                SPEED=9600
                PROTOCOL=KISS
                KISSOPTIONS=POLLED,CHECKSUM,ACKMODE
                MTU=256
                FLOW=0
        ENDINTERFACE

        TYPE, COM, SPEED, PROTOCOL and MTU are mandatory.

        ID is an optional plain text string which identifies the
        interface on various displays. Keep it concise. 20 characters
        max.

        COM is the serial device name, e.g. "/dev/tty0". COM=0 is a
        "dummy" device which reads and writes nothing. It can be used
        to "park" interfaces when not in use.

        SPEED is the baud rate used on the interface. Don't include a
        comma, e.g use "9600" not "9,600". The range of supported baud
        rates depends on the device.

        PROTOCOL is the protocol to use on the interface:

             ASCII    - Remote consoles (TTY)
             DEDHOST  - DEDHOST emulation
             KISS     - For driving KISS TNCs or wired links.
             MODEM    - Hayes compatible PSTN modem.
             NETROM   - Netrom backend serial link.
             PPP      - Point to Point Protocol (TCP/IP over RS232)
             SLIP     - Serial Line Internet Protocol (ditto)
             TNC2     - TNC2 emulation.

             (see PROTOCOL(7) for more detail)

        MTU is the "Maximum Transmission Unit". This specifies the
        maximum size for the data portion of an IP packet transmitted
        on the interface.

        Datagrams are sized or fragmented according to the MTU of the
        interface on which they are transmitted.

        XRouter allows MTU's up to 1500 bytes, but setting MTU over
        256 is not recommended on AX25 ports, because the buffer size
        on TNC-based nodes is usually only big enough for a 256-byte
        data field.

        FLOW optionally specifies the flow control options:

             0 = No flow control
             1 = Hardware (RTS/CTS) flow control
             2 = Software (XON/XOFF) flow control (TTY link only)
             3 = Hardware AND software flow control

        If not specified, flow control defaults to NONE. Don't use
        Xon/Xoff with KISS!.

        CONFIG specifies special confifiguration for certain protocols.
        For KISS, it may optionally be used to specify a sequence of
        commands which switch a TNC into KISS mode at startup.

        RADIO secifies the number of the radio (if any) controlled by
        this interface. Required only if rig control is needed. 

        KISSOPTIONS are special options for the KISS protocol only:

             NONE     - Plain KISS (most TNC's use this) (default)

             POLLED   - For TNCs which send only when polled.

             CHECKSUM - Packets are protected by checksum.  You can
                        only use this option if your TNC supports it.

             ACKMODE  - For TNC's which inform XRouter when a
                           frame has been transmitted on air.

             SLAVE    - XRouter will act like a polled KISS TNC,
                        sending only when commanded to do so.

        POLLED and SLAVE are mutually exclusive. BPQKISS eproms require
        POLLED and CHECKSUM, but their use of ACKMODE is optional.

SEE ALSO
        IFACES(6)      -- Interfaces.
        PORTS(6)       -- Ports.
        PROTOCOL(7)    -- Protocol Used on INTERFACE.
        XROUTER.CFG(8) -- Main Configuration File.

ASYNC-IFACE(6)              END OF DOCUMENT
