AUDIO(9)                XROUTER REFERENCE MANUAL               2/9/2023

NAME
        AUDIO -- Audio Output.

DESCRIPTION
        Raspberry Pi's and modern laptops do not have the traditional
       "PC speaker", so they cannot play the usual console bells and
        alerts. However, a sound device can be used instead.

        To enable sounds (assuming a suitable sound device is
        present), put the following directive anywhere in XROUTER.CFG

        # Audio device for sound output:
        # Default OSS device is /dev/dsp (/dev/audio on Rasp pi)
        #
        AUDIODEVICE=/dev/dsp
        #

        This uses OSS, (a) because OSS has been found to work much
        better than ALSA, and (b) because ALSA requires the host
        machine to have the "libasound" library installed. The
        XRouter philosophy is to avoid dependencies where possible.

        Having said that, XRouter can be supplied in "with-ALSA"
        versions if required.

        In order to use sound, on some platforms you may need to
        first run the command:

              sudo modprobe snd-pcm-oss

        The command only needs to be run once. Thereafter XRouter
        can be started and stopped without needing to use it again.

        On some platforms the modprobe command is not needed at all,
        but Linux has been gradually phasing out OSS, making it ever
        more awkward to use.

        You could add "snd-pcm-oss" into the /etc/modules file, which
        causes it to load the module at bootup.

        If snd-pcm-oss is not found on the system, and cannot be
        installed from a repository, one method which has been found
        to be successful is to run XRouter from within an OSS
        "wrapper" program such as "aoss" like this:

               "aoss /home/pi/xrouter/xrpi"

CAVEATS
        The downside of OSS is that it won't share the audio device,
        so if you have XRouter's audio enabled but another app is
        already using the sound device, XRouter will fail at boot.

SEE ALSO
        AUDIODEVICE(7)    -- Specify Audio Device
        BELL(1)           -- Console sounds control
        XROUTER.CFG(8)    -- Main Configuration File.

AUDIO(9)                    END OF DOCUMENT
