AUDIODEVICE(7)            XROUTER REFERENCE MANUAL            4/9/2023

NAME
        AUDIODEVICE -- Specify audio device name.

SYNOPSIS
        AUDIODEVICE=<devicename>

AVAILABILITY
        Used only in XROUTER.CFG.

DESCRIPTION
        AUDIODEVICE is a global configuration keyword used in
        XROUTER.CFG to specify the audio device to use for console
        sounds such as warning bells.

        If AUDIODEVICE is not specified, sound output is via the PC
        speaker, if one is fitted.

        XRouter uses OSS (Open Sound System) (a) because OSS has been
        found to work much better than ALSA, and (b) because ALSA
        requires the host machine to have the "libasound" library
        installed. The XRouter philosophy is to avoid dependencies
        where possible.

        Having said that, XRouter can be supplied in "with-ALSA"
        versions if required.

EXAMPLE
        # Audio device for sound output:
        # Default OSS device is /dev/dsp (/dev/audio on Rasp pi)
        #
        AUDIODEVICE=/dev/dsp
        #

CAVEATS
        Linux has been gradually trying to force the use of ALSA by
        making it more difficult to access OSS. In this case XRouter
        can be run inside a "wrapper" progream such as AOSS as
        follows:

               "aoss /home/pi/xrouter/xrpi"

SEE ALSO
        AUDIO(9)       -- Audio on XRouter
        BELL(1)        -- Set acceptable hours for console sounds.
        XROUTER.CFG(8) -- Main Configuration File.

AUDIODEVICE(7)                END OF DOCUMENT
