AUTOQUAL(9)             XROUTER REFERENCE MANUAL            19/10/2023

NAME
        AUTOQUAL -- Automatic Route Quality.

DESCRIPTION
        Automatic Route Quality Measurement" (Autoqual) is an optional
        tool to help sysops set consistent and meaningful NetRom route
        qualities.

        Background
        ~~~~~~~~~~

        NetRom makes routing decisions based on a fairly arbitrary
        metric, i.e. the "route quality", which is assigned by sysops,
        and disseminated in nodes broadcasts.

        In the better-managed parts of the NetRom network, route
        qualities tend to be assigned according to the baud rate of
        the link, with adjustments for retry rates, duplex / simplex
        and shared channels.

        However, there is no standard methodology for assigning
        quality, so not only will each sysop's notion of quality
        differ from that of other sysops, but also he will probably
        incorrectly assign the relative qualities of his own links.
        This leads to inconsistency and distorted routing.

        In other parts of the network, route qualities are simply
        assigned to 192 regardless of how good or bad the link is.
        This also leads to inconsistency and less-than-optimal
        routing decisions.

        The actual "goodness" of a link may continually change with
        atmospheric conditions, data throughput, other channel
        activity, QRM etc.  At certain times of day for example, it
        may be better to use an alternative link.

        A more accurate notion of "goodness" is simply the "Round
        Trip Time" (RTT) for the link, i.e. the time taken to send a
        packet and get a reply.  After all, this is what *really*
        matters to users. A link which responds quickly (i.e. with a
        low RTT) is perceived by users to be better than a link which
        responds slowly.  The RTT will track changes in retry rate,
        channel loading etc.

        The RTT can be easily and consistently measured by software
        on a continuous basis, thus the "goodness" of the link is
        accurately known at all times, and all routers of the same
        type will give comparable values independently of the sysop's
        notions of quality.


        Implementation
        ~~~~~~~~~~~~~~

        XRouter continually measures the RTT of neighbour links and
        uses the smoothed value to calculate a notional "route
        quality" every 5 minutes.  The maximum, minimum and standard
        deviation  of this quality are calculated and recorded for
        later display, and the value is further smoothed.  
  
        The smoothed calculated quality is displayed by the "R Q"
        command, and can either be used as a guide to allow the sysop
        to fix the RQ at a sensible value, or if the route has been
        configured for it, XRouter can use it dynamically, by setting
        the route's quality to the calculated value.

        This RTT to quality conversion is tailored to the British
        notion of quality, which gives somewhat lower but more
        meaningful qualities than used elsewhere.  For example, a
        typical 1200 baud half-duplex link with low retry rate would
        produce a calculated quality around 120. A good 9600 baud half
        duplex link would equate to around 190, with 210 for a really
        good full duplex 9k6 link.

        RTT measurement primarily uses L3RTT frames, but in their
        absence it also uses measurements of traffic throughput and
        retry rate.


        Enabling Automatic Route Quality
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Route quality calculation is automatic and continuous.
        However the calculated value is not actually used without the
        sysop's consent.

        In order to allow the route quality to be automatically
        adjusted, the sysop must specify a RQ between 256 and 511
        when adding a route using the "ROUTE ADD" command. 

        Alternatively, setting the PORT quality between 256 and 511
        will cause all *new* routes (not locked in ones) learned on
        that port to use automatic quality. 
  
        A quality between 256 and 511 will instruct XRouter to use
        "automatic" quality, with an initial value of (qual-256).      

SEE ALSO
        ROUTES(1)  -- Add, Drop and List NetRom Routes.
        QUALITY(7) -- Default NetRom Quality.

AUTOQUAL(9)                 END OF DOCUMENT
