;***********************|****** Max Width *****|*********************|
AXIP-IFACE(6)           XROUTER REFERENCE MANUAL             26/9/2023

NAME
        AXIP-IFACE -- Interface Type "AXIP".

DESCRIPTION
        The AXIP interface is used, in conjunction with one or more
        PORTs, to provide AX25-over-IP links with other nodes.

        In this mode of operation, AX25 (plus CRC) is encapsulated
        within IP. This is less versatile that AXUDP, and only saves
        8 "internet" bytes per frame. See AXIP(9) for a more detailed
        explanation of AXIP.

        The AX25 links created using AXIP can in turn support NetRom
        and amateur TCP/IP, just like real radio links. 

        An AXIP interface is defined in XROUTER.CFG as follows:

            INTERFACE=7
                TYPE=AXIP
                MTU=256
            ENDINTERFACE

            (Choose the interface number to suit yourself).

        This interface can support an unlimited number of PORTs. You
        may define multiple interfaces if your ports need different
        MTU's.

        Only TYPE=AXIP and MTU= are required; all other directives
        are ignored (at present).

        Each AXIP partner link requires its own PORT, in which the
        link parameters are defined. This is like operating an RF
        link on an exclusive frequency. The PORT is specified
        similar to this:

            PORT=8
                ID=AXIP link with WA3IP
                INTERFACENUM=7     <-- Points to the INTERFACE above
                IPLINK=55.73.88.69 <-- Partner's IP address/hostname
                FRACK=2000
                RESPTIME=200
            ENDPORT

        You must specify at least ID, INTERFACENUM, and IPLINK.

        IPLINK is the remote host's IP address or hostname. It is
        more efficient to use IP addresses, if you are able to do so,
        because it removes the need to resolve the hostnames.

        To link with an AXIP partner on the SAME machine use a
        "localhost" address, e.g. "IPLINK=127.0.0.2".

        MAC parameters such as TXDELAY, TXTAIL, SLOTTIME, PERSIST,
        FULLDUP, SOFTDCD etc. are meaningless for AXUDP, but FRACK,
        RESPTIME, PACLEN, MAXFRAME, QUALITY etc. operate as normal.

        On fast internet links you may wish to use a much lower FRACK,
        say 2000ms, than on radio. It is not recommended that you
        reduce it much below 1000ms, as it needs to be *at least*
        twice the worst round-trip time plus the other end's RESPTIME.

        RESPTIME is probably the one which will have most effect on
        the responsiveness of the AX25 link, because it controls the
        time delay between receiving a packet and sending an ACK. It
        should be just a little more than the time it takes to receive
        a maximum length packet. For example, at a data rate of
        56Kbits/sec, a 256 byte packet lasts less than 50msec, so
        RESPTIME=50 would be adequate. However the timing jitter due
        to operating on a multi-tasking operating system means that
        RESPTIME should be more like 200ms

NOTES
        If no IPADDRESS is specified in XROUTER.CFG, AXIP is disabled.

        If there's either an EXTERN or a TUN interface, and IPLINK is
        not a "localhost" address, AXIP uses the XRouter stack, and
        will require correct IP routing to be set up in IPROUTE.SYS.

        If there's no EXTERN or TUN interface, or IPLINK is a
        localhost address, AXIP uses the Linux stack.

        In all cases XRouter will need the CAP_NET_RAW capability,
        unless it is run from a root account.

CAVEATS
        If you have more than one node on your LAN using AXIP, your
        Internet router is only able to direct incoming AXIP to *one*
        of them. This means you can only have one AXIP node per
        public IP address. If you need more than one node, use AXUDP.

        DO NOT set up an AXIP link to a link partner if you already
        have an AXUDP link to that partner. This is a common mistake,
        and is likely to cause problems! 

SEE ALSO
        AXIP(9)        -- About AXIP.
        IFACES(6)      -- Interfaces in XRouter.
        CAPFLAGS(6)    -- Capability Flags.
        PORTS(6)       -- Ports in XRouter.
        RUNROOT(6)     -- To Run as Root?
        XROUTER.CFG(8) -- Main Configuration File.

AXIP-IFACE(6)               END OF DOCUMENT
