AXIP(9)                 XROUTER REFERENCE MANUAL            21/10/2023

NAME
        AXIP -- AX25-over-IP Tunnelling.

DESCRIPTION
        AXIP is AX25 "encapsulated" within IP datagrams.  This
        enables AX25 systems to communicate with each other via
        TCP/IP networks (e.g. the Internet).  The frame structure is
        as follows :

                .-----------.------------------------.-----.
                | IP header |        AX25 frame      | CRC |
                '-----------'------------------------'-----'
                  (20 bytes) (Typically 15-340 bytes)  2 bytes


        The AX25 links created using AXIP can in turn support NetRom
        and amateur TCP/IP, just like real radio links.


        Setting Up AXIP Links
        ~~~~~~~~~~~~~~~~~~~~~~

        Assuming you have a prospective AXIP partner, you would set
        up an AXIP link as follows:

        1)  Configure and test IP routing between you and your
            partner. If you don't have reliable IP routing there's no
            point in proceeding!

            If you are linking via the Internet, it makes sense to
            use the Internet IP addresses for this purpose, rather
            than the amateur (44.x.x.x) ones, because the routing is
            more reliable and the throughput is faster.

        2)  If your partner has a dynamic IP address, they must have
            an account with a "dynamic DNS" provider, and you must
            use the hostname thus provided for all operations.  If
            you use the IP address instead, the link will stop
            working when the address changes.

        3)  If you wish to use your prospective partner's hostname
            (e.g. "g8pzt.ath.cx") instead of their IP address, your
            system needs access to a Domain Name Server (DNS).  This
            would usually be provided by Linux nowadays, so you may
            remove all "DNS=" lines from XROUTER.CFG.

        4)  If using the partner's hostname, verify that
            "PING <hostname>" resolves the address correctly.

        5)  Add an AXIP interface to XROUTER.CFG as follows:

                INTERFACE=7
                    TYPE=AXIP
                    MTU=256
                ENDINTERFACE

            (Choose the interface number to suit yourself).

            This interface can support an unlimited number of AXIP
            PORTs.  You may define multiple interfaces if your ports
            need different MTU's.

            Only TYPE=AXIP and MTU= are required, all other
            parameters are ignored (at present).

        6)  For each AXIP partner, add a PORT similar to this:

                PORT=8
                    ID=AXIP link with WA3IP
                    INTERFACENUM=7   <-- Points to INTERFACE above
                    IPLINK=55.73.88.69
                    FRACK=2000
                    RESPTIME=200
                ENDPORT

            You must specify at least ID, INTERFACENUM, and IPLINK.  

            IPLINK is the remote host's IP address or hostname. It is
            more efficient to use IP addresses, if you are able to do
            so, because it removes the need to resolve the hostnames,
            but see (2) above.   The assigned "protocol number" for
            AXIP is 93 (decimal).
            
            MAC parameters such as TXDELAY, TXTAIL, FULLDUP, PERSIST, 
            SLOTTIME, SOFTDCD etc. are meaningless for AXIP, but
            FRACK, RESPTIME, PACLEN, MAXFRAME, QUALITY etc. operate
            as normal.  
          
            On fast internet links you may wish to use a much lower
            FRACK, say 2000ms, than on radio.  It is not recommended
            that you reduce it much below 1000ms, as it needs to be
            *at least* twice the worst round-trip time plus the other
            end's RESPTIME.
        
            RESPTIME is probably the one which will have most effect
            on the responsiveness of the AX25 link, because it
            controls the time delay between receiving a packet and
            sending an ACK.  It should be just a little more than the
            time it takes to receive a maximum length packet.  For
            example, at a data rate of 56Kbits/sec, a 256 byte packet
            lasts less than 50msec, so RESPTIME=50 would be adequate.
            However the timing jitter due to operating under Windows
            means that RESPTIME should be more like 200ms.

        7)  If XRouter is indirectly connected to the Internet via an
            intermediate router, that router will probably be using
            some form of NAT (Network Address Translation) to share
            one "public" IP address between several systems on your
            LAN.  The "front end" router will probably route outgoing
            AXIP without problem, but it will not know where to send
            incoming AXIP unless explicitly configured.

            Configuring such a router for AXIP usually involves
            specifying a protocol number (93 for AXIP), and the LAN
            IP address of a machine to which it should be routed,
            i.e. XRouter's LAN IP address.

            You are advised that not all domestic routers can be
            configured to route incoming AXIP as it is not a
            commercially recognised protocol.  Some routers only
            allow TCP and UDP port redirection, with no provision for
            any other protocol.  If you or your link partner have
            such a router, you may need to consider AXUDP instead -
            see later.

        8)  Your link partner must set up a reciprocal arrangement,
            i.e. their IPREMOTE must be set to your public IP address
            or hostname.

        If everything has been set up correctly, you should be able
        to connect with your new neighbour node immediately, at least
        at AX25 layer 2.  You can test this by entering the command
        "C n ALIAS-1", where n is the PORT number of your link, and
        ALIAS is the node alias of your link partner. If this doesn't
        work, you or your partner have made a mistake somewhere in
        the configuration.

        Even if everything is configured correctly, it may take a
        while for NetRom to configure itself for the new link, as the
        nodes need to exchange NODES broadcasts first.  Once they
        have done so, there should be no delays in future.


        Notes
        ~~~~~

        You may of course use AXIP to communicate between nodes on
        the LAN, as long as they are not on the same machine.

        If you have more than one node on your LAN using AXIP, your
        Internet router is only able to direct incoming AXIP to *one*
        of them.  This means you can only have one AXIP node per
        public IP address.

        DO NOT set up an AXIP link to a link partner if you already
        have an AXUDP link.  This is a common mistake, and is likely
        to cause problems!

        Using one port per neighbour may seem wasteful, but it is a
        reliable method, and it allows you to monitor exactly what is
        going on.

 
        IP Routing Over AXIP
        ~~~~~~~~~~~~~~~~~~~~

        As mentioned earlier, you may route amateur IP (44.x.x.x) over
        your new AXIP link, and are encouraged to do so. Whilst the
        amprnet purists will argue that this is not as efficient as
        IP-over-IP (since it uses a few more bytes), it is a LOT
        easier to set up, and doesn't require that your domestic
        router and operating system can route IP-over-IP (many
        routers are not able to route incoming IP-over-IP to a
        specific PC, and Windows' IP stack totally blocks IP-over-IP).

        To route amateur IP over an AXIP link, simply add an IP route
        entry directing the required subnet to your neighbour's IP
        address on the AXIP port using datagram mode. For example, if
        the AXIP port is port 8, and the link partner (44.136.20.2)
        is able to accept all amprnet traffic for Australia, the
        entry would look like this:

           IP ROUTE ADD 44.136.0.0/16  44.136.20.2  8  d

        The source IP address for this mode of routing is the
        IPADDRESS of the AXIP port. Therefore, if XRouter's main
        IPADDRESS (in XROUTER.CFG) is not a 44-net address, you must
        override it with a 44-net address on the AXIP port.  If the
        main IPADDRESS is a 44-net address, which is the recommended
        configuration, do not specify IPADDRESS in the PORT
        configuration block.

SEE ALSO
        AXUDP(9)        -- AX25-over-UDP Encapsulation
        IP(1)           -- IP Routing / Configuration Commands.
        IPENCAP(9)      -- IP-in-IP Encapsulation.
        IPLINK(1)       -- Display / Set a Port's IPLINK.
        IPLINK(7)       -- Peer Address of a Link.
        IP-PRIMER(9)    -- IP Addressing / Routing Primer.
        IPROUTE.SYS(8)  -- IP Routing / Configuration File.
        XROUTER.CFG(8)  -- Main Configuration File

AXIP(9)                     END OF DOCUMENT
