AXSCTRL(9)              XROUTER REFERENCE MANUAL            19/10/2023

NAME
        AXSCTRL -- TCP/IP Access Control.

SYNOPSIS
        This file deals with "access control", and is mainly of
        concern if your system is directly connected to a non-amateur
        TCP/IP network such as the Internet.

DESCRIPTION
        Some of the users who access your system via the Internet may
        be genuine Radio Amateurs, who may legitimately downlink on
        radio frequencies, while other users may not. And different
        countries may have different rules governing the
        inter-connection of radio and non-radio networks.

        Therefore some form of configurable access control is
        required, and this is provided by the entries in ACCESS.SYS,
        which specify the login requirements according to the
        caller's IP address. For example you may specify that hosts
        on your private LAN require no password.

        If ACCESS.SYS is not present, the default action is for logins
        to require a valid callsign only.

        The entries in ACCESS.SYS allow various levels of access
        control, e.g. username only, valid amateur radio callsign
        only, username plus password, and valid callsign plus
        password. They may also be configured for "guest access".
        This is intended to let people look around, but not to do
        anything that would cause a transmission to be made.

        Guests are prevented from using the SEND, CHAT and CONNECT
        commands, and from sending APRS messages using the APRS
        messaging shell.  For the TELNET command they are restricted
        by the rules in the file TELGUEST.ACL. If that file is not
        present, guests are denied access to the TELNET command.

        Guests are not necessarily unlicenced people. They may simply
        be hams who don't yet have a password for your system.

        If an entry in ACCESS.SYS specifies that a login password is
        required, the password should be located in file USERPASS.SYS.

        Failure to meet the access requirements results in immediate
        disconnection of the caller.

        Sysop access using the "@" command, RLOGIN (tcp port 513) and
        FTP do not use USERPASS.SYS, and are all controlled instead
        by entries in the sysop password file, PASSWORD.SYS.

        The "@" command, which is normally performed on publicly
        visible radio links, uses the password to send a grid of
        numbers, from which the caller must select one line and send
        the matching characters from the password.

        FTP uses the password grid method, but can be configured to
        use use plain password (secure wired links only) if SYSOP=1
        has been included in the appropriate PORT configuration in
        XROUTER.CFG.

        RLOGIN must only be used on secure wired networks because the
        caller must send the password itself.  

        Access to the APRS server is normally controlled by the
        "Validation number" which the user obtains from the author of
        his APRS client program upon registration.  However, if the
        user has not registered his client, he may be granted access
        to the server by including his callsign and a password in
        USERPASS.SYS.

        The Telnet Proxy and AGWHOST servers also use passwords in
        USERPASS.SYS.

        For further information you are referred to the sections
        detailing the ACCESS.SYS, PASSWORD.SYS and USERPASS.SYS
        files.

SEE ALSO
        ACCESS.SYS(8)   -- Telnet Access Control File.
        APRS-SRV(9)     -- APRS Server.
        IDS(9)          -- Intrusion Detection System.
        PASSWORD.SYS(8) -- Sysop Password File.
        USERPASS.SYS(8) -- User Passwords File.
        XROUTER.CFG(8)  -- Main Configuration File.

AXSCTRL(9)                  END OF DOCUMENT
