;***********************|****** Max Width *****|*********************|
AXTCP-IFACE(6)          XROUTER REFERENCE MANUAL             29/9/2023

NAME
        AXTCP-IFACE -- Interface Type "AXTCP".

DESCRIPTION
        The AXTCP interface is used, in conjunction with a single
        PORT, to provide AX25-over-TCP links with other nodes.

        In this mode of operation, AX25 (plus CRC) is encapsulated
        within TCP streams (see AXTCP(9) for details). Unlike AXIP
        and AXUDP, AXTCP can work through NAT and firewalls, which is
        particularly useful for "mobile" nodes, which can't set up
        "port forwarding".

        The AX25 links created using AXTCP can in turn support NetRom
        and amateur TCP/IP, just like real radio links. 

        AXTCP interfaces can act as server, client, or both at once,
        depending on which keywords are included. Servers require
        "port forwarding", clients do not.

        An AXTCP server can support several simultaneous client
        connections, and a client can connect to several servers
        simultaneously.

        AXTCP is enabled by declaring an INTERFACE with TYPE=AXTCP. A
        single PORT is then attached to that interface.

        If the interface definition includes INTNUM, it will be a
        server. If it includes CONFIG it will be a client. If it
        includes both directives, it will be both server and client.

        Example AXTCP Server Interface
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       
                INTERFACE=5           <-- change to suit yourself
                        TYPE=AXTCP
                        MTU=256
                        INTNUM=9393   <- Server port
                ENDINTERFACE

        The INTNUM parameter activates server mode and specifies the
        TCP port that it listens on.  If this is zero, or not
        specified, the server is disabled. 


        Example AXTCP Client Interface
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 
                INTERFACE=5
                        TYPE=AXTCP
                        MTU=256
                        CONFIG=KIDDER g8pzt.ath.cx 9393
                ENDINTERFACE

        The CONFIG directive activates client mode and specifies to 
        which server it will connect. The format is as follows:

             CONFIG=<alias> <hostname | ipaddr> <tcp_port>

             <alias> is the NetRom "alias" of the server
             <hostname>, <ipaddr> and <tcp_port> are those of the
              server

        You may specify additional servers, by including a CONFIG for
        each one.  There is no limit to the number of CONFIG
        directives that can be used with a single interface. 


        Combined AXTCP Client/Server Interface
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        A combined interface is specified by including both INTNUM and
        CONFIG directives.  For example, this combines a server
        listening on TCP port 9393 with 3 client connections: 
        
                INTERFACE=5
                        TYPE=AXTCP
                        INTNUM=9393
                        MTU=256
                        CONFIG=DORSET 216.23.45.91 10093
                        CONFIG=WALES gw3xr.dyndns.org 9394
                        CONFIG=Brum bm23.ath.cx 7507
                ENDINTERFACE

        This is just an example, and it could only be used at a
        "static" node, in which case the client connections could
        be replaced by AXIP or AXUDP anyway.

        Such a configuration *couldn't* be used for "mobile" node,
        because there's no way of directing incoming TCP port 9393 to
        a mobile server!  


        AXTCP PORT Settings
        ~~~~~~~~~~~~~~~~~~~
        A PORT attached to an AXTCP interface needs no special
        configuration, and should simply be configured with
        parameters (FRACK, RESPTIME, RFBAUDS) appropriate to a high
        speed connection, for example:

                PORT=8
                    ID=AXTCP Operations
                    INTERFACENUM=5
                    FRACK=2000
                    RESPTIME=200
                    RFBAUDS=56000
                ENDPORT

        MAC parameters such as TXDELAY, TXTAIL, SLOTTIME, PERSIST,
        FULLDUP, SOFTDCD etc. are meaningless for AXUDP, but FRACK,
        RESPTIME, PACLEN, MAXFRAME, QUALITY etc. operate as normal.  
          
        On fast internet links you may wish to use a much lower FRACK,
        say 2000ms, than on radio.  It is not recommended that you
        reduce it much below 1000ms, as it needs to be *at least*
        twice the worst round-trip time plus the other end's RESPTIME.
        
        RESPTIME is probably the one which will have most effect on
        the responsiveness of the AX25 link, because it controls the
        time delay between receiving a packet and sending an ACK.  It
        should be just a little more than the time it takes to receive
        a maximum length packet.  For example, at a data rate of
        56Kbits/sec, a 256 byte packet lasts less than 50msec, so
        RESPTIME=50 would be adequate.  However the timing jitter due
        to operating under Windows means that RESPTIME should be more
        like 200ms.

        By default, all AXTCP connections use the same PORT, but if
        you prefer to use one port per neighbour, see the following
        section.  You must NOT attach more than one PORT to an AXTCP
        interface. 


        Multiple Interfaces / Ports
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~
        A single AXTCP server can accommodate many clients, so there
        is no practical need to use more than one AXTCP interface and
        port.

        This is analogous to having several nodes on the same radio
        frequency, except that the nodes don't see each other's
        transmissions, and there is no "hidden station" effect.

        You may however prefer to assign each AXTCP partner to a
        seperate port, analogous to having a dedicated radio
        frequency for each neighbour.  In this case you may configure
        several interfaces, each with a single PORT attached.

        The only proviso is that no two AXTCP interfaces may use the
        same INTNUM.

NOTES
        When configuring a server, you must ensure that incoming
        TCP/IP connections are directed to the server's TCP port, i.e.
        there must be suitable NAT entries or "port forwarding" set
        up in the Internet "front end" router.

        AXTCP always uses the Linux IP stack, so the port forwarding
        should be directed at the Linux IP address NOT XRouter's.

        If INTNUM is below 1024, XRouter will need to be granted the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        AXTCP(9)       -- About AXTCP.
        IFACES(6)      -- Interfaces in XRouter.
        CAPFLAGS(6)    -- Capability Flags.
        PORTS(6)       -- Ports in XRouter.
        RUNROOT(6)     -- To Run as Root?
        XROUTER.CFG(8) -- Main Configuration File.

AXTCP-IFACE(6)               END OF DOCUMENT
