;***********************|****** Max Width *****|*********************|
AXTCP(9)                XROUTER REFERENCE MANUAL             29/9/2023

NAME
        AXTCP -- AX25-over-TCP Tunnelling.

DESCRIPTION
        AXTCP is AX25 "encapsulated" within a TCP stream.  This
        enables AX25 systems to communicate with each other via TCP/IP
        networks (e.g. the Internet) in a similar way to AXIP and
        AXUDP.  The frame structure is as follows:

            .-----.--------.---------.--------------------.-----.
            | Len | IP hdr | TCP hdr |      AX25 frame    | CRC |
            '-----'--------'---------'--------------------'-----'
        Bytes: 2      20       20       Typically 15-340     2

            (Len = (framelength-2), CRC = Cyclic Redundancy Check)

        AXTCP is particularly useful when it isn't possible to route
        AXIP or AXUDP, as detailed below:

        The Problem
        ~~~~~~~~~~~ 
        Many people in the UK use mobile broadband "dongles" to
        provide their Internet connection, either because it's a lower
        cost option than fixed-line broadband, or because the latter
        is not available in their area, or because they're "roving".

        As an example of the latter, a "mobile" node may be
        established in a vehicle and used to provide a local packet
        "hot-spot" for special events, emergency datacomms etc. It may
        be using mobile broadband, WiFi or other available Internet
        connections, and it is highly unlikely that such a connection
        could be configured to route AXIP or AXUDP. 

        The characteristics of mobile Internet which prevent the use
        of AXIP or AXUDP are that (a) the subscriber's IP address is
        volatile (so you can't set IPLINK), and (b) the subscriber is
        on a private network behind a NAT firewall, which doesn't pass
        incoming AXIP or AXUDP traffic!

        The solution
        ~~~~~~~~~~~~
        AXTCP offers a solution to these problems.  It differs from
        AXIP and AXUDP in three respects:

        - Firstly, it uses a bidirectional stream protocol (TCP/IP)
          which guarantees that the packets can flow in both
          directions, even through several stages of NAT and
          firewalling.

        - Secondly, it uses a client-server approach where the fixed
          server has no need to know the mobile client's IP address
          and port number.  The connection is initiated by the client,
          and the server simply responds via that connection.

        - And thirdly, the TCP protocol ensures that no AX25 packets
          are lost. 

        The AX25 links created using AXTCP can in turn support NetRom
        and amateur TCP/IP, just like real radio links.

        To use AXTCP, the "static" node is configured as an AXTCP
        server, and the "mobile" node as an AXTCP client.


        Configuring XRouter for AXTCP
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        AXTCP is enabled by declaring an INTERFACE with TYPE=AXTCP. A
        single PORT is then attached to that interface.

        AXTCP interfaces can act as server, client, or both at once,
        depending on which keywords are included.

        An AXTCP server can support several simultaneous client
        connections, and a client can connect to several servers
        simultaneously.

        Note: When configuring a server, you must ensure that incoming
        TCP/IP connections are directed to the server's TCP port, i.e.
        there must be suitable NAT entries or "port forwarding" set
        up in the Internet "front end" router.
 

        Example AXTCP Server Interface
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        The following configures an AXTCP server, listening for
        clients on TCP port 9393:

                INTERFACE=5           <-- change to suit yourself
                        TYPE=AXTCP
                        MTU=256
                        INTNUM=9393   <- Server port
                ENDINTERFACE

        The INTNUM parameter activates the server and specifies the
        TCP port that it listens on.  If this is zero, or not
        specified, the server is disabled. 


        Example AXTCP Client Interface
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        This specifies a client which connects with the KIDDER node,
        whose address is g8pzt.ath.cx, port 9393:
 
                INTERFACE=5
                        TYPE=AXTCP
                        MTU=256
                        CONFIG=KIDDER g8pzt.ath.cx 9393
                ENDINTERFACE

        The CONFIG directive is used to specify a server, thereby
        activating client mode.  The format is as follows:

             CONFIG=<servalias> <hostname | ipaddr> <tcp_port>

        You may specify additional servers, by including a CONFIG for
        each one.  There is no limit to the number of CONFIG
        directives that can be used with a single interface. 


        Combined AXTCP Client/Server Interface
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        A combined interface is specified by including both INTNUM and
        CONFIG directives.  For example, this combines a server
        listening on TCP port 9393 with 3 client connections: 
        
                INTERFACE=5
                        TYPE=AXTCP
                        INTNUM=9393
                        MTU=256
                        CONFIG=DORSET 216.23.45.91 10093
                        CONFIG=WALES gw3xr.dyndns.org 9394
                        CONFIG=Brum bm23.ath.cx 7507
                ENDINTERFACE

        This is just an example, and it could only be used at a
        "static" node, in which case the client connections could
        be replaced by AXIP or AXUDP anyway.

        Such a configuration *couldn't* be used for "mobile" node,
        because there's no way of directing incoming TCP port 9393 to
        a mobile server!  


        AXTCP PORT Settings
        ~~~~~~~~~~~~~~~~~~~
        A PORT attached to an AXTCP interface needs no special
        configuration, and should simply be configured with
        parameters (FRACK, RESPTIME, RFBAUDS) approriate to a high
        speed connection, for example:

                PORT=8
                    ID=AXTCP Operations
                    INTERFACENUM=5
                    FRACK=2000
                    RESPTIME=200
                    RFBAUDS=56000
                ENDPORT

        MAC parameters such as TXDELAY, TXTAIL, SLOTTIME, PERSIST,
        FULLDUP, SOFTDCD etc. are meaningless for AXUDP, but FRACK,
        RESPTIME, PACLEN, MAXFRAME, QUALITY etc. operate as normal.  
          
        On fast internet links you may wish to use a much lower FRACK,
        say 2000ms, than on radio.  It is not recommended that you
        reduce it much below 1000ms, as it needs to be *at least*
        twice the worst round-trip time plus the other end's RESPTIME.
        
        RESPTIME is probably the one which will have most effect on
        the responsiveness of the AX25 link, because it controls the
        time delay between receiving a packet and sending an ACK.  It
        should be just a little more than the time it takes to receive
        a maximum length packet.  For example, at a data rate of
        56Kbits/sec, a 256 byte packet lasts less than 50msec, so
        RESPTIME=50 would be adequate.  However the timing jitter due
        to operating under Windows means that RESPTIME should be more
        like 200ms.

        By default, all AXTCP connections use the same PORT, but if
        you prefer to use one port per neighbour, see the following
        section.  You must NOT attach more than one PORT to an AXTCP
        interface. 


        Multiple Interfaces / Ports
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~
        A single AXTCP server can accommodate many clients, so there
        is no practical need to use more than one AXTCP interface and
        port.

        This is analogous to having several nodes on the same radio
        frequency, except that the nodes don't see each other's
        transmissions, and there is no "hidden station" effect.

        You may however prefer to assign each AXTCP partner to a
        seperate port, analogous to having a dedicated radio
        frequency for each neighbour.  In this case you may configure
        several interfaces, each with a single PORT attached.

        The only proviso is that if INTNUM is used, no two AXTCP
        interfaces may use the same INTNUM.


        Transaction Logging
        ~~~~~~~~~~~~~~~~~~~
        If the AXTCP option of LOGFLAGS is non-zero, XRouter logs
        AXTCP connections and disconnections, otherwise nothing is
        logged.

NOTES
        When a client connects to a server, it should immediately be
        possible to force an AX25 level 2 connection from either
        client or server, by entering the command "C n ALIAS-1",
        where n is the AXTCP port number, and ALIAS is the node alias
        of the peer.

        However, it may take a few minutes for the client and server
        to commence NetRom operations, because each end must first
        receive a nodes broadcast from the other.  The link-up time
        will be shorter if a prior link has been made recently.  It
        is hoped to speed up the linking time in a later version.

SEE ALSO
        AXTCP-IFACE(6)  -- AXTCP Interface.
        AXIP(9)         -- AX25-over-IP Encapsulation
        AXUDP(9)        -- AX25-over-UDP Encapsulation
        XROUTER.CFG(8)  -- Main Configuration File

AXTCP(9)                  END OF DOCUMENT
