;***********************|****** Max Width *****|*********************|
AXUDP-IFACE(6)          XROUTER REFERENCE MANUAL             26/9/2023

NAME
        AXUDP-IFACE -- Interface Type "AXUDP".

DESCRIPTION
        The AXUDP interface is used, in conjunction with one or more
        PORTs, to provide AX25-over-UDP links with other nodes.

        In this mode of operation, AX25 (plus CRC) is encapsulated
        within UDP/IP. This is more versatile that AXIP, and only
        costs an extra 8 bytes per frame. See AXUDP(9) for a more
        detailed explanation of AXUDP.

        The AX25 links created using AXUDP can in turn support NetRom
        and amateur TCP/IP, just like real radio links. 

        An AXUDP interface is defined in XROUTER.CFG as follows:

            INTERFACE=9
                TYPE=AXUDP
                MTU=256
            ENDINTERFACE

            (Choose the interface number to suit yourself).

        This interface can support an unlimited number of PORTs. You
        may define multiple interfaces if your ports need different
        MTU's.

        Only TYPE=AXUDP and MTU= are required; all other directives
        are ignored (at present).

        Each AXUDP partner link requires its own PORT, where the link
        parameters are defined. This is like operating an RF link on
        an exclusive frequency. The PORT is specified similar to this:

            PORT=8
                ID=AXUDP link with VK1UDP
                INTERFACENUM=9
                IPLINK=27.69.88.73
                UDPLOCAL=93
                UDPREMOTE=93
                FRACK=2000
                RESPTIME=200
            ENDPORT

        You must specify at least ID, INTERFACENUM, and IPLINK.

        IPLINK is the remote host's IP address or hostname. It is
        more efficient to use IP addresses, if you are able to do so,
        because it removes the need to resolve the hostnames.

        UDPLOCAL and UDPREMOTE are the UDP "service port" numbers for
        each end of the link, and if omitted they default to 93. The
        numbers are independent, e.g. you may use 93 for UDPLOCAL and
        10093 for UDPREMOTE.

        MAC parameters such as TXDELAY, TXTAIL, SLOTTIME, PERSIST,
        FULLDUP, SOFTDCD etc. are meaningless for AXUDP, but FRACK,
        RESPTIME, PACLEN, MAXFRAME, QUALITY etc. operate as normal.

        On fast internet links you may wish to use a much lower FRACK,
        say 2000ms, than on radio. It is not recommended that you
        reduce it much below 1000ms, as it needs to be *at least*
        twice the worst round-trip time plus the other end's RESPTIME.

        RESPTIME is probably the one which will have most effect on
        the responsiveness of the AX25 link, because it controls the
        time delay between receiving a packet and sending an ACK. It
        should be just a little more than the time it takes to receive
        a maximum length packet. For example, at a data rate of
        56Kbits/sec, a 256 byte packet lasts less than 50msec, so
        RESPTIME=50 would be adequate. However the timing jitter due
        to operating on a multi-tasking operating system means that
        RESPTIME should be more like 200ms

NOTES
        The "rules" that determine which IP stack is used are a little
        complicated, and may be simplified in future:

        - If no IPADDRESS has been defined, AXUDP is totally blocked.

        - If the IPLINK is any LOCALHOST address, or no ETHERNET port
          is present, AXUDP uses the LINUX stack.

        - If an ETHERNET port is present, and IPLINK is NOT a
          LOCALHOST address, AXUDP uses XRouter's IP stack.

        - If XRouter's IP stack is used, IP routing must be set up
          correctly.

CAVEATS
        If the Linux IP stack is used, and UDPLOCAL is below 1024,
        XRouter will need CAP_NET_BIND_SERVICE capability, or will
        need to run from a "root" account.

SEE ALSO
        AXUDP(9)       -- About AXUDP.
        IFACES(6)      -- Interfaces in XRouter.
        CAPFLAGS(6)    -- Capability Flags.
        KISS(9)        -- KISS Protocol.
        PORTS(6)       -- Ports in XRouter.
        RUNROOT(6)     -- To Run as Root?
        XROUTER.CFG(8) -- Main Configuration File.

AXUDP-IFACE(6)             END OF DOCUMENT
