AXUDP(9)                XROUTER REFERENCE MANUAL            21/10/2023

NAME
        AXUDP -- AX25-over-UDP Tunnelling.

DESCRIPTION
        AXUDP is AX25 "encapsulated" within UDP datagrams.  This
        enables AX25 systems to communicate with each other via
        TCP/IP networks (e.g. the Internet).  The frame structure is
        as follows:

          .-----------.------------.------------------------.-----.
          | IP header | UDP header |        AX25 frame      | CRC |
          '-----------'------------'------------------------'-----'
               (20 bytes)  (8 bytes)   (Typically 15-340 bytes) 

        It is slightly less efficient than AXIP, because there is an
        extra 8 byte UDP header between the IP header and AX25
        portion of the frame, but the difference is not significant.  

        One of the problems with AXIP is that many domestic routers
        cannot be configured to route AXIP to a specific PC. And even
        if they can, it can only be routed to one PC. This means you
        can only have one AXIP node per public IP address.

        The major advantage of AXUDP over AXIP is that it can usually
        be handled by domestic Internet routers without problem. And
        since UDP is a "ported" protocol (AXIP is "portless") you may
        have more than one AXUDP node on the same public IP address,
        by assigning them different UDP ports. The domestic router is
        then able to route incoming packets according to UDP port.

        The AX25 links created using AXUDP can in turn support NetRom
        and amateur TCP/IP, just like real radio links.

OPTIONS
        There are two main ways to set up formal AXUDP links, namely
        "One-Link-Per-Port" (recommended) or "Many-Links-Per-Port"
        (the BPQ way). Configuration of these is discussed later.

        Although "One-Link-Per-Port" uses more PORTs, it is the more
        flexible option. It is analagous to a full duplex radio link
        on a private frequency. It allows all the link parameters to
        be configured independently of any other link. It also allows
        the traffic to be monitored and captured without clutter from
        other traffic. It is more efficient in terms of processing,
        and supports connections to any of the peer's callsigns,
        SSIDs or aliases without any extra configuration.

        The "Many-Links-Per-Port" option is analogous to a radio link
        on a shared frequency. All ax25 connections have to share the
        same PORT parameters, and it is difficult to monitor one link
        without clutter from the others. It is computationally less
        efficient, and only supports connections to pre-defined SSIDs
        and aliases.

        Both of the above methods can co-exist.

CONFIGURATION
        Assuming you have a prospective AXUDP partner, both of the
        above mentioned methods require steps 1 through 5 below:

        1)  Configure and test IP routing between you and your
            partner. If you don't have reliable IP routing there's no
            point in proceeding!

            If you are linking via the Internet, it makes sense to
            use the Internet IP addresses for this purpose, rather
            than the amateur (44.x.x.x) ones, because the routing is
            more reliable and the throughput is faster.

        2)  If your partner has a dynamic IP address, they must have
            an account with a "dynamic DNS" provider, and you must
            use the hostname thus provided for all operations.  If
            you use the IP address instead, the link will stop
            working when the address changes.

        3)  If you wish to use your prospective partner's hostname
            (e.g. "g8pzt.ath.cx") instead of their IP address, your
            system needs access to a Domain Name Server (DNS).  This
            would usually be provided by Windows or Linux nowadays,
            so you may remove all "DNS=" lines from XROUTER.CFG.

        4)  If using the partner's hostname, verify that
            "PING <hostname>" resolves the address correctly.

        5)  Add an AXUDP interface to XROUTER.CFG as follows:

                INTERFACE=9
                    TYPE=AXUDP
                    MTU=256
                ENDINTERFACE

            (Choose the interface number to suit yourself).

            This interface can support an unlimited number of AXUDP
            PORTs.  You may define multiple interfaces if your ports
            need different MTU's.

            Only TYPE=AXUDP and MTU= are required, all other
            parameters are ignored (at present).

        Step 6 has two mutually exclusive alternatives. 6a is for
        "One-Link-Per-Port" and 6b is for "Multiple-Links-Per-Port".

        6a) One-Link-Per-Port:

            For each AXUDP partner, add an AXUDP port similar to this:

                PORT=8
                    ID=AXUDP link with VK1UDP
                    INTERFACENUM=9
                    IPLINK=27.69.88.73
                    UDPLOCAL=93
                    UDPREMOTE=93
                    FRACK=2000
                    RESPTIME=200
                ENDPORT

            You must specify at least ID, INTERFACENUM, and IPLINK.  

            IPLINK is the link partner's IP address or hostname.  It
            is more efficient to use IP addresses, if you are able to
            do so, because it removes the need to resolve the
            hostnames, but see (2) above.

            UDPLOCAL and UDPREMOTE are the UDP "service port" numbers
            for each end of the link, and if omitted they default to
            93 (don't confuse these with *protocol number* 93, which
            is AXIP). The numbers are independent, e.g. you may use
            93 for UDPLOCAL and 10093 for UDPREMOTE). 

            MAC parameters such as TXDELAY, TXTAIL, FULLDUP, PERSIST, 
            SLOTTIME, SOFTDCD etc. are meaningless for AXUDP, but
            Layer 2 parameters such as FRACK, RESPTIME, PACLEN,
            MAXFRAME, QUALITY etc. operate as normal.  
          
            On fast Internet links you may wish to use a much lower
            FRACK, say 2000ms, than on radio.  It is not recommended
            that you reduce it much below 1000ms, as it needs to be
            *at least* twice the worst round-trip time plus the other
            end's RESPTIME.
        
            RESPTIME is probably the one which will have most effect
            on the responsiveness of the AX25 link, because it
            controls the time delay between receiving a packet and
            sending an ACK.  It should be just a little more than the
            time it takes to receive a maximum length packet.  For
            example, at a data rate of 56Kbits/sec, a 256 byte packet
            lasts less than 50msec, so RESPTIME=50 would be adequate.
            However the timing jitter due to operating under Windows
            means that RESPTIME should be more like 200ms.

        6b) Multiple-Links-Per-Port

            This mode requires only ONE port, configured similar to
            the following:

               PORT=8
                    ID=AXUDP links
                    INTERFACENUM=9             
                    IPLINK=0.0.0.0
                    UDPLOCAL=10093
                    PEER=VK2DOT:DOTXR vk2dot.dyndns.org 9394
                    PEER=G8PZT-7 127.0.0.1 2345
                    PEER=G9DUM-3:DUMMY g9dum.ath.cx 10078
                    FRACK=2000
                    RESPTIME=200
                ENDPORT

            IPLINK must be present and must be exactly "0.0.0.0",
            otherwise it won't work.

            UDPLOCAL is the UDP service number on which XRouter
            listens for incoming AXUDP packets. This MUST be different
            from the service numbers used on any other PORTs.

            Note that UDPREMOTE must NOT be used in this case. The
            PEER statements are used instead.

        7)  If XRouter is indirectly connected to the Internet via an
            intermediate router, that router will probably be using
            some form of NAT (Network Address Translation) to share
            one "public" IP address between several systems on your
            LAN.  The "front end" router will probably route outgoing
            AXUDP without problem, but it will not know where to send
            incoming AXUDP unless explicitly configured.

            Configuring such a router for AXUDP usually involves
            specifying a UDP port number (your UDPLOCAL as specified
            above), and the LAN IP address of a machine to which it
            should be routed, i.e. Xrouter's LAN IP address. This is
            sometimes called "port forwarding".  There are websites
            (e.g. portforward.com) dedicated to showing you how to do
            this for most makes of router. 

            Some routers don't have the facility to open specific UDP
            ports, but at the very least should allow you to direct
            all UDP traffic to a specified IP address.

        8)  Your link partner must set up a reciprocal arrangement,
            i.e. their UDPREMOTE must match your UDPLOCAL and vice
            versa.

        If everything has been set up correctly, you should be able
        to connect with your new neighbour node immediately, at least
        at AX25 layer 2.  You can test this by entering the command
        "C n ALIAS-1", where n is the PORT number of your link, and
        ALIAS is the node alias of your link partner. If this doesn't
        work, you or your partner have made a mistake somewhere in
        the configuration.

        Even if everything is configured correctly, it may take a
        while for NetRom to configure itself for the new link, as the
        nodes need to exchange NODES brodcasts first.  Once they have
        done so, there should be no delays in future.


NOTES
        You may of course use AXUDP to communicate between nodes on
        the LAN, or even on the same machine.

        If you have more than one node on your LAN using AXUDP, your
        UDPLOCAL must not be the same as the UDPLOCAL (or equivalent
        thereof) of any other node on your LAN.  There are two
        reasons for this; Firstly, for a given UDP port, NAT routers
        cannot direct direct incoming traffic to more than one LAN IP
        address at a time.  Secondly, only one application on a PC
        may "own" a given UDP port number.

        Unlike other software, you *DO NOT* need a different UDPLOCAL
        for each AXUDP port.  It is quite common for link partners to
        specify that they will transmit AXUDP to you on a UDP port
        that is different to your other UDPLOCAL settings.  There is
        absolutely *NO* valid reason for this! It makes life more
        complicated for you, and you have to set up extra "port
        forwarding" entries in your NAT router.  For these reasons
        you are strongly advised to use the same UDPLOCAL for all
        AXUDP partners on a given node.  As a rule, you may NOT tell
        a link partner what his UDPLOCAL should be, no more than he
        should dictate what your UDPLOCAL should be. Instead, he
        should specify which UDP port he is listening on (which
        becomes your UDPREMOTE), and in return you tell him which UDP
        port you are listening on (which becomes his UDPREMOTE).

        DO NOT set up an AXUDP link to a link partner with whom you
        already have an AXIP link.  This is a common mistake, and is
        likely to cause problems!


IP ROUTING
        As mentioned earlier, you may route amateur IP (44.x.x.x)
        over your new AXUDP link, and are encouraged to do so. Whilst
        the amprnet purists will argue that this is not as efficient
        as IP-over-IP (since it uses a few more bytes), it is a LOT
        easier to set up, and doesn't require that your domestic
        router and operating system can route IP-over-IP (many
        routers are not able to route incoming IP-over-IP to a
        specific PC, and Windows' IP stack blocks IP-over-IP).

        To route amateur IP over an AXUDP link, simply add an IP
        route entry directing the required subnet to your neighbour's
        IP address on the AXUDP port using datagram mode. For
        example, if the AXUDP port is port 8, and the link partner
        (44.136.20.2) is able to accept all amprnet traffic for
        Australia, the entry would look like this:

           IP ROUTE ADD 44.136.0.0/16  44.136.20.2  8  d

        The source IP address for this mode of routing is the
        IPADDRESS of the AXUDP port. Therefore, if XRouter's main
        IPADDRESS (in XROUTER.CFG) is not a 44-net address, you must
        override it with a 44-net address on the AXUDP port.  If the
        main IPADDRESS is a 44-net address, which is the recommended
        configuration, do not specify IPADDRESS in the PORT
        configuration block.

SEE ALSO
        AD-HOC(9)       -- Ad-Hoc Networking.
        AXIP(9)         -- AX25-over-IP Encapsulation
        IP(1)           -- IP Routing / Configuration Commands.
        IPENCAP(9)      -- IP-in-IP Encapsulation.
        IPLINK(1)       -- Display / Set a Port's IPLINK.
        IPLINK(7)       -- Peer Address of a Link.
        IP-PRIMER(9)    -- IP Addressing / Routing Primer.
        IPROUTE.SYS(8)  -- IP Routing / Configuration File.
        LEARN(7)        -- Learn Unsolicited AX*P Peer Details.
        UDPLOCAL(1)     -- Display / Set a Port's UDPLOCAL.
        UDPREMOTE(1)    -- Display / Set a Port's UDPREMOTE.
        XROUTER.CFG(8)  -- Main Configuration File

AXUDP(9)                    END OF DOCUMENT
