BCAST(9)              XROUTER REFERENCE MANUAL              21/10/2023

NAME
        BCAST -- UI Broadcasting.

DESCRIPTION
        XRouter has the ability to "re-broadcast" a received UI frame
        onto several ports at once.  This can be thought of as a
        "one-to-many" PIPE, but there are subtle differences:

        Whereas pipes conduct all frames of the selected type(s),
        virtually regardless of source and destination addresses
        (unless they are selective pipes), the broadcast function
        acts only upon UI frames, and only if the source and
        destination addresses match those specified by the sysop.

        Another difference is that frames may be broadcast to
        different groups of ports depending on the destination
        address.  For example, FBB unproto headers from a BBS may be
        rebroadcast on certain user-access ports only, while mail
        beacons may be distributed to a different, possibly
        overlapping, set of ports.

        You may alternatively use this feature as a "filtered pipe"
        between two ports, allowing only UI frames with acceptable
        source and destination callsigns to pass through.

        Note that this feature does not require a "connection" to
        XRouter, it is purely an unconnected mode.  It was developed
        to allow BBS's to distribute mail beacons and "unproto" mail
        headers.  You may use it (or not) how you wish.

        You should be aware that broadcast traffic takes precedence
        over all other frames, so an excessively high level of
        broadcast activity may cause other outbound traffic on the
        destination port to be delayed. However, it is unlikely that
        anyone will notice this effect unless the channel is
        seriously overloading.

        Broadcasting is controlled by two keywords in each PORT
        section of the XROUTER.CFG file.  The first keyword is BCAST,
        which is used to specify the destination addresses to be
        broadcasted.

        For example, BCAST=MAIL,FBB will re-broadcast received
        non-digipeater UI frames addressed either to FBB or MAIL.
        The frames addressed to FBB will be broadcast on all ports
        which have FBB in their BCAST list, and those addressed to
        MAIL are broadcast on all ports which have MAIL in the BCAST
        list.

        If no matching ports are found, the frame is broadcast only
        on the port upon which it is received.  If you don't need the
        broadcast function, simply omit (or comment out) the BCAST
        directive.

        The second keyword is BCFROM, which is used to specify a list
        of callsigns from whom frames will be accepted for broadcast.

        You may use this to restrict the broadcast facility to
        certain senders only. BCFROM applies only to frames
        *directly* received on the port for which it is specified. 
        e.g. BCFROM=GB7PZT,GB7MAX stipulates that only frames from
        GB7MAX and GB7PZT will be accepted for broadcast.  If the
        keyword is omitted, the broadcast facility is unrestricted.
        
        For both keywords, the list of callsigns must be separated by
        commas, and must include no spaces.

CAVEATS
        Be careful not to configure BCAST and PIPE together in a way
        which causes infinite loops. This is a common cause of
        crashes.

SEE ALSO
        BCAST(7)       -- Destinations for UI Broadcasting.
        BCFROM(7)      -- Approved UI Broadcasters.
        PIPES(9)       -- Frame Pipes.
        XROUTER.CFG(8) -- Main Configuration File.

BCAST(9)                    END OF DOCUMENT
