BELL(1)                 XROUTER REFERENCE MANUAL              4/9/2023

COMMAND
        BELL -- Display / Set bell times.

SYNOPSIS
        BE[ll] [h,h h-h] 

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The BELL command is used to display and set the hours during
        which the console bells will sound.  These are the two tone
        connection (low->high) and disconnection (high->low) bells,
        the 4 tone (Star Trek doorbell) sysop paging sound, and the
        various bells associated with sysop chat.

        Console sounds normally use the PC speaker, but Raspberry
        Pi's and modern laptops don't have speakers. In such cases,
        a sound device can be used instead (see AUDIO(9)).

OPTIONS
        When used without arguments, the current times are displayed.

        To set the bell times, the times may be supplied either as a
        series of single hours, or in one or more ranges of times
        e.g. "8-22", or as combinations of the two.

EXAMPLES
        BELL 12         - Bells only between 12:00 and 12:59
        BELL 0-4, 12-23 - Allow bells between midday and 4am next day.

CAVEATS
        Whatever the BELL setting, the console may still bleep if the
        sysop tries to exceed a line length or delete back beyond
        the start of a line.

NOTES
        The default bell times are 08:00 to 22:59 inclusive. The BELL
        command may be used in BOOTCMDS.SYS to override this
        Alternatively the BELL= directive can be used in XROUTER.CFG,
        like so...

             # Acceptable bell hours, format n,n,n-n n etc
             BELL=0-5,11-23

SEE ALSO
        AUDIODEVICE(7) -- Specify audio device name
        AUDIO(9)       -- About audio in XRouter

BELL(1)                    END OF DOCUMENT
