BLOG(1)               XROUTER REFERENCE MANUAL                7/9/2023

COMMAND
        BLOG -- Access Sysop's Blog(s)

SYNOPSIS
        BL[og] [nodecall | nodealias] 

DESCRIPTION
        The BLOG command connects the user either to the sysop's blog
        either at this node, or on another XRouter. 

        The blog is a text-only, packet radio version of an Internet
        "web log". It is a space for sysops to post "articles", which
        other people can "like" or reply to.

        Unlike the "wall", only SYSOPS can create original articles.
        These have no size restrictions, and may contain paragraphs
        and markup. Anyone may add comments to an existing article.
        Comments are not restricted in size.

        Blog articles are not forwarded to other packet systems, but
        may optionally be published to an MQTT broker.

        The blog may also be operated via the sysop's web interface,
        via MQTT, and via REST.

        The BLOGFLAGS directive enables or disables the blog, and
        controls whether the sysop is notified (via the PMS) of new
        likes and replies. It also controls whether articles and
        replies are published to the MQTT broker.
 
OPTIONS
        If no argument is supplied to the BLOG command, the user is
        connected to the local blog.

        If the argument is the nodecall or alias of another XRouter,
        which is in the nodes table, the user is connected to the
        blog of that node instead.

        After connecting to the blog, the available commands are as
        follows:

        B[ye]       Returns you to the node (same as Q[uit]).

        C[reate]    Begins creation of a blog article (sysop-only).
                    Text is entered in the same manner as for a PMS,
                    and is terminated by "/EX" on a new line.

        D[elete]    Deletes an article or reply.

        H[elp]      Displays a help summary.

        LIK[e] [n]  (shortcut "K") is used to "like" either the
                    article you've just read, or article number "n".

        L[ist]      Displays or re-displays the header information of
                    up to 5 articles at a time. Headers are displayed
                    in reverse chronological order, i.e. the most
                    recent at the top.

        N[ewer]     Displays up to 5 newer (more recent) articles.

        O[lder]     Displays up to 5 older (less recent) articles.

        Q[uit]      Returns you to the node (same as B[ye].

        R[ead] n    Reads article number "n". Or you can omit the 'R'
                    and use the number alone.

        REP[ly] [n] (shortcut "Y") begins a reply to the article
                    you've just read, or to article number "n".

        V[iew] [n]  View replies to current article, or article "n".

EXAMPLES
        BLOG       -- Connect to the PMS on this node.
        BLOG G8PZT -- Connect to the PMS on G8PZT node.

AVAILABILITY
        All users.

PHILOSOPHY
        A blog on Packet Radio might sound like a crazy idea, but is
        it any crazier than a packet bulletin board? Even though there
        are many Internet forums, people still run packet bulletin 
        boards!

        There are millions of blogs on the Internet, but can you
        remember all the URL's? Will they still be there tomorrow? Are
        they riddled with cookies, trojans and clickbait? Are they
        easy to use? Shouldn't packet blogs be hosted on PACKET?

        In order to survive, Packet Radio needs CONTENT. There's no
        point having a network if that network has nothing to do. The
        purpose of a network is to move DATA. A blog is just another
        form of data. It gives people a reason to use the network.

        The Sysop's blog is just another tool in the communications
        toolbox. Hopefully some sysops may contribute their thoughts,
        and others will find them interesting and thought provoking, 
        but you don't have to use it.

SEE ALSO
        BLOGFLAGS(7)   -- Options For Sysop's Blog.
        MQTT-BLOG(9)   -- MQTT Interface to Blog.
        MQTT-SRV(9)    -- MQTT Server / Broker
        PMS(1)         -- Personal Message System.
        REST-BLOG(9)   -- REST Interface to Blog.
        WALL(1)        -- Message Wall / Guestbook.
        XROUTER.CFG(8) -- Main Configuration File.

BLOG(1)                     END OF DOCUMENT
