BOOTCMDS.SYS(8)         XROUTER REFERENCE MANUAL            17/10/2023

NAME
        BOOTCMDS.SYS -- Commands to Execute at Bootup.

DESCRIPTION
        This optional file is read by XRouter at boot time, after
        XROUTER.CFG and IPROUTE.SYS.  It is mainly used for
        configuration commands that have no keywords in XROUTER.CFG,
        such as the GNET and PPP commands.

FORMAT
        Format is exactly the same as keyboard-entered commands,
        with one command per line. Lines beginning with '#' or ';'
        are ignored, and may be used for comments.

OPTIONS
        Whilst many commands *can* be used in BOOTCMDS.SYS, there is
        often no point in doing so, because they duplicate the
        function of configuration directives. For example there's no
        point including "Paclen 3 120", when it is just as easy to
        put PACLEN=120 in the port 3's configuration block. However,
        most of the commands listed below can also be used in
        CRONTAB.SYS, where they DO have a purpose.

        Commands that can be used in BOOTCMDS.SYS are as follows:

        ACL, APPLMASK, ARP, BCAST, BELL, BLEVEL, CAPTURE, CFLAGS,
        CTEXT, CTFLAGS, CTRL, DIAL, DHCP, DIGIFLAG, DIGIPORT, DNS,
        DUN, EXCLUDE, EXIT, FEC, FRACK, FULLDUP, GNET, ID, IDPATH,
        IDS, IDTEXT, IFACE, IPADDRESS, IPLINK, LOADNODES, LOG,
        MAXFRAME, MDIR, MFROM, MHCLEAR, MHFLAGS, MHSIZE, MINQUAL,
        MINTXQUAL, MMASK, MON, MPORT, MQTT, MTO, NAT, NETMASK,
        NODESINT, NOTIFY, ODN, PACLEN, PCAP, PEERS, PERSIST, PING,
        PIPE, PIPEFLAG, PORT, PPP, QUALITY, RESPTIME, RESTART,
        RETRIES, RIP, ROUTE, SAVENODES, SEND, SHELL, SLOTTIME, START,
        STATS, STOP, TCP, TSYNC, TXDELAY, TXOK, TXPORT, TXTAIL, UDP,
        UDPLOCAL, UDPREMOTE, UNPROTO, USERS, WAIT, WX.

EXAMPLES
        # This is a comment line
        GNET ADDR 131.91.1.1
        GNET ROUTE ADD 147.38.1.1 zl2aqy

SEE ALSO
        CRONTAB.SYS(8) -- Event Control File.
        XROUTER.CFG(8) -- Main Configuration File.

BOOTCMDS.SYS(8)              END OF DOCUMENT
