;*************************** Max Width *******************************
CAPFLAGS(6)            XROUTER REFERENCE MANUAL              23/9/2023

NAME
        CAPFLAGS -- Capability Flags

DESCRIPTION
        Starting with kernel 2.2, Linux divides the privileges
        traditionally associated with super-user into distinct units,
        known as "capabilities", which can be independently enabled
        and disabled.

        This allows non-privileged processes to be granted certain
        enhanced permissions without having to run the process as a
        privileged user.

        If XRouter is "run as root", i.e. it is started from a
        terminal which has "root" (super-user) privileges, it needs
        no further permissions.

        Otherwise, it will need CAP_NET_RAW capability in order to
        use TCP/IP via the LAN, WiFi or localhost. And it will need
        CAP_NET_BIND_SERVICE if you wish to open any "service ports"
        on the linux TCP/IP stack whose numbers are below 1024.

        Note: You do NOT need either of these capabilites for TCP/IP
        via serial ports, e.g. SLIP, KISS, AX25, PPP etc. You only
        need them for TCP/IP via LAN or WLAN.

        Program capabilities are changed using the Linux "setcap"
        command in a termnal window. Only a privileged user can
        confer privileges, so you must be root, or you must use
        "sudo".

        Once you have set XRouter's capability flags, you don't need
        to do it again unless you change the executable. 

EXAMPLES
        The following examples assume that the XRouter executable
        file is called "xrpi".

        Checking the capabilities:

             getcap xrpi

        Setting only the CAP_BET_BIND_SERVICE capability:

             sudo setcap cap_net_bind_service=pe xrpi

        Setting only the CAP_NET_RAW capability:

             sudo setcap cap_net_raw=pe xrpi

        Setting both capabilities:

             sudo setcap cap_net_raw,cap_net_bind_service=pe xrpi

CAVEATS
        Running XRouter with super-user privileges is easier and more
        convenient than running it as an unprivileged user. But
        technically it is more of a security risk. See RUNROOT(9) for
        more discussion about the pros and cons of running as root. 

SEE ALSO
        IP-STACKS(6) -- IP Stacks in XRouter.
        TCP-PORTS(6) -- TCP Server Ports.
        LAN(6)       -- LAN Interfacing.
        RUNROOT(6)   -- To Root or Not to Root?

CAPFLAGS(6)                  END OF DOCUMENT
