CFLAGS(7)               XROUTER REFERENCE MANUAL              4/9/2023

NAME
        CFLAGS -- Connection Control Flags.

SYNOPSIS
        CFLAGS=n (n = 0 - 255)

AVAILABILITY
        Used in PORT configuration blocks within XROUTER.CFG.

DESCRIPTION
        CFLAGS is a port configuration keyword, whose primary function
        is to control whether or not AX25 level 2 uplinking and/or
        downlinking is allowed on the port. A command of the same
        name allows the value to be changed on the fly.

        A typical use may be to prevent users from uplinking and
        downlinking on APRS-only ports.

        It also allows the sysop to control whether or not L3RTT
        frames are generated on inter-node links, and whether or not
        AX25 level 2 fragmentation is allowed on the port.

OPTIONS
        Add together the decimal values of the desired options from
        this list:

           Bit Dec   Function
           ---------------------------------------------------------
            0   1  - Allow incoming connections (uplinks).
            1   2  - Allow outgoing connections (downlinks).
            2   4  - Applications may downlink unconditionally.
            3   8  - Suppress L3RTT generation.
            4  16  - Allow L2 fragmentation.

        The default value is 3, i.e. unconditional use of the port.

        Irrespective of the setting of CFLAGS, the Sysop can always
        downlink.

        Bit 2 allows applications to downlink unconditionally, i.e.
        even if users are prevented from downlinking. 

        Bit 3 was provided to keep the Luddites happy, but its use is
        strongly deprecated.  Setting this flag prevents L3RTT frames
        from being originated by the port if it is carrying an
        inter-node link.  It will not prevent XRouter from trying to
        hold inter-node links open, as that is too much of a
        retrograde step!  This bit is not set by default.  Note that
        L3RTT may also be suppressed if a route's MAXTT is 65535.

        Bit 4 allows AX25 layer 2 fragmentation if it is set.  This is
        required if Forward Error Correction (FEC) is in use, to allow
        big L3 frames to be sent.

EXAMPLES
                CFLAGS=2  - Allow downlinking only
                CFLAGS=5  - Allow only sysops and apps to downlink.
  
FILES
        xrouter.cfg

SEE ALSO
        CFLAGS(1)      -- Display / Set Connection Flags
        L2FRAG(9)      -- AX25 Layer 2 Fragmentation.
        L3RTT(9)       -- Layer 3 Round Trip Time.
        FEC(1)         -- Forward Error Correction.
        XROUTER.CFG(8) -- Main Configuration File.

CFLAGS(7)                 END OF DOCUMENT
