CFLAGS(1)               XROUTER REFERENCE MANUAL              4/9/2023

COMMAND
        CFLAGS -- Display / Change Connection Control Flags.

SYNOPSIS
        CF[lags] <port> [0-31]

AVAILABILITY
        Sysop-only.

DESCRIPTION
        CFLAGS is a port configuration command, whose primary
        function is to control whether or not AX25 level 2
        uplinking and/or downlinking is allowed on the port.

        A typical use may be to prevent users from uplinking and
        downlinking on APRS-only ports.

        It also allows the sysop to control whether or not L3RTT
        frames are generated on inter-node links, and whether or not
        AX25 level 2 fragmentation is allowed on the port.

        A directive of the same name can be used in PORT config
        blocks within XROUTER.CFG.

OPTIONS
        Add together the decimal values of the desired options from
        this list:

           Bit Dec   Function
           ---------------------------------------------------------
            0   1  - Allow incoming connections (uplinks).
            1   2  - Allow outgoing connections (downlinks).
            2   4  - Applications may downlink unconditionally.
            3   8  - Suppress L3RTT generation.
            4  16  - Allow L2 fragmentation.

        The default value is 3, i.e. unconditional use of the port.

        Irrespective of the setting of CFLAGS, the Sysop can always
        downlink.

        Bit 2 allows applications to downlink unconditionally, i.e.
        even if users are prevented from downlinking. 

        Bit 3 was provided to keep the Luddites happy, but its use is
        strongly deprecated.  Setting this flag prevents L3RTT frames
        from being originated by the port if it is carrying an
        inter-node link.  It will not prevent XRouter from trying to
        hold inter-node links open, as that is too much of a
        retrograde step!  This bit is not set by default.  Note that
        L3RTT may also be suppressed if a route's MAXTT is 65535.

        Bit 4 allows AX25 layer 2 fragmentation if it is set.  This is
        required if Forward Error Correction (FEC) is in use, to allow
        big L3 frames to be sent.

EXAMPLES
        CFLAGS 4  - Display current value for port 4
        CF 4 5    - Only sysops and apps can downlink on port 4.
  
SEE ALSO
        CFLAGS(7)      -- Set connection control flags.
        L2FRAG(9)      -- AX25 Layer 2 Fragmentation.
        L3RTT(9)       -- Layer 3 Round Trip Time.
        FEC(1)         -- Forward Error Correction.
        XROUTER.CFG(8) -- Main Configuration File.

CFLAGS(1)                 END OF DOCUMENT
