CHAT-SRV(9)             XROUTER REFERENCE MANUAL            21/10/2023

NAME
        CHAT-SRV -- CHAT Server.

DESCRIPTION
        XRouter's integral chat server allows groups of users to hold
        live multi-way conversations without having to manage several
        TNC streams at once.

        It is available to all callers, and is accessed by using the
        CHAT command at the main prompt, or by connecting to NetRomX
        service 2, or by connecting directly to the server's callsign
        or alias.  TCP/IP users can additionally access it by
        TELNETting to port 3600 (this port can be reassigned or
        disabled using the CHATPORT directive in XROUTER.CFG).

        Sysops have a "always-on" chat window for chatting amongst
        themselves on channel 1234, and there is a "chat monitor"
        window for keeping an eye on chat activity.

        The server is tri-standard, i.e. it can exist on, and
        interact with, 3 completely different types of chat network
        simultaneously, namely XRchat, "Tampa Ping Pong Converse",
        and W0RLI RoundTable chat, as used by BPQ.

        XRouter's chat server is a fully functional RoundTable node,
        however data is NEVER transferred between networks. e.g. what
        is said on the RoundTable network is never propogated around
        the XRchat network and vice versa.


        Channels
        ~~~~~~~~

        The "XRchat" system has 32767 channels or " chat rooms", each
        of which can support an unlimited number of users, so it is
        possible for groups to have their own "private" room, or to
        reserve certain rooms for specific topics.

        Channels 1 to 255 (except 101 - see below) are "local" to
        each chat server, and the remaining channels 256-32767 are
        "global", i.e. they are linked with all other XRouter chat
        servers, providing there is at least one link set up with
        another server.

        Room 101 is a gateway to the W0RLI "RoundTable" / BPQChat
        network, providing there is at least one link with a
        RoundTable or BPQChat peer. Within room 101, users may create
        and occupy private chat spaces called "topics". The default
        topic at login is "general".

        In addition to the "positive" channel numbers, there are
        another 32768 channels numbered 0 to -32767.  These
        correspond to channels 0 to 32767 on the "Tampa Ping Pong"
        system.

        XRouter allows only limited interconnection between these two
        systems, because the channel layouts and topologies are
        completely incompatible.  XRchat was specifically designed
        for use on an anarchic, slow radio network, whereas Ping-Pong
        requires a more planned network topology to avoid loops, and
        is largely carried on Internet links.  The sheer volume of
        chat in the Ping-Pong system would overwhelm marginal radio
        links.

        Data received from Ping-pong is not propogated via the
        XRouter chat interlinks and vice versa.  In effect, XRouter
        can be a stub Ping-Pong host, but not part of the Ping-Pong
        backbone.  

        Channel 1000 is the default channel to which users are
        assigned at log-on, but they may set their preferred login
        channel using the "/CHANNEL DEFAULT" command.

        Users may "join" as many channels as they wish, so they may
        take part in several separate conversations at once. Users
        may listen on any number of positive and negative channels
        simultaneously, but may only *send* on one channel at a time.

        Once logged onto a channel, anything sent by the user is
        copied to all other users of that channel, except for lines
        beginning with a forward slash (/), which are interpreted as
        chat server commands.  The  distributed text is prefixed by
        the channel number and the sender's callsign and name, to
        allow the recipients to identify who sent it.


        Commands
        ~~~~~~~~

        All chat server commands begin with a forward slash (/), and
        most of them may be abbreviated to the initial letter.  The
        /? command shows the available commands and syntax, while
        /HELP gives more details. 

        The /NAME command is used to enter the user's first name, and
        serves as a "login".  Users are not permitted to join any
        channels until they have supplied a name.  TCP/IP users must
        additionally supply a callsign with the /USER command.

        /CHANNEL, /JOIN and /LEAVE are used to select the desired
        channel, /WHO shows the active channels and who is using them,
        and /QUIT terminates the chat session.  The full command set
        is shown in more detail in the command reference section.

        Users who log on to more than one chat server at once are
        treated as separate entities, and must supply their name and
        callsign on each server. Note that the RoundTable network
        does not allow a user to be logged on at more than one server,
        but there are often valid reasons for doing so, therefore the
        XRchat protocol allows multiple logins by design.


        Configuration
        ~~~~~~~~~~~~~

        The chat server is fully automatic and requires minimal
        setting up. It is configured using entries in XROUTER.CFG as
        follows:

        CHATCALL defines the chat callsign for AX25 and NetRom
        operations. A SSID of -8 is strongly recommended for all
        XRchat systems.

        CHATALIAS specifies the alias for AX25 and NetRom operations.
        It is recommended that this should begin with something
        geographically relevant, and end with "CHT" e.g. BHMCHT for
        Birmingham, LDSCHT for Leeds etc., so it can be easily
        identified in node tables.

        CHATQUAL specifies the NetRom "quality" assigned to the chat
        server and alias for L3/4 operations. If set to 0, the server
        will not be visible on the network.
        A setting of 255 makes the chat server as visible as the
        node, which just fills up the nodes tables. A value somewhere
        in between, to give medium visibility, is suggested.

        CHATLOG specifies the amount of detail that is logged. A value
        of 0 suppresses logging. Add together the values corresponding
        to the desired options from this table:

                1      Local user connect / disconnect event
                2      Remote user connect / disconnect event
                4      Peer server connect / disconnect event
                8      Local channels 1-255 join / leave events
                16     Public channel join / leave events
                32     Log channel notifications
                64     Log the text of conversations
                128    Use a single logfile, instead of daily ones


        CHATPORT adjusts or disables the TCP port which the chat
        server normally listens on. The default is 3600, but you may
        need to adjust this if you have another system or application
        using that port.    

        CHATLINKS specifies the callsigns of other servers to link to.

        - Only NetRom links are allowed with RoundTable/BPQChat peers.

        - Only TCP/IP links are allowed to Tampa Ping-Pong peers.

        - Links with XRChat peers may use either NetRom or TCP/IP,
          but NetRom is the norm.

        If NetRom linking is used, you must specify the peer's
        CALLSIGN not the alias. The peer's callsign and alias must
        exist in your nodes table, i.e. you can't link with peers
        beyond the NetRom "horizon".
   
        Unilateral linking is not allowed, and will not work.  You
        *must* co-ordinate it with your peers, such that you are in
        their CHATLINKS list and they are in yours.

        You should avoid linking to peer servers via slow links.  If
        the link isn't up to the job, frames will be dumped, and the
        users will therefore get a poor service.

        Peer links may be added and removed at any time using the
        /LInks command.


        Links With XRouter Peers
        ~~~~~~~~~~~~~~~~~~~~~~~~

        NetRom links with XRouter chat peers are specified in
        XROUTER.CFG as follows (you can put several peers in one
        CHATLINKS directive, or use one directive per link, or any
        combination thereof):

                CHATLINKS=<netrom_call>,<netrom_call>,...
           e.g. CHATLINKS=GB7GH-7,GB7BM-8,N0LBA-8

        or at the chat command prompt:

                /LI ADD <netrom_call>
           e.g. /LI ADD GB7BX-9

        For TCP/IP links with XRouter chat peers, the IP address and
        TCP "port" number must be specified, along with the CHATALIAS
        of the peer server, and you can only specify one peer per
        line.

                CHATLINKS=<ip_address>:<tcp_port> <peer_alias>
        e.g.    CHATLINKS=67.69.96.23:3600 KDRCHT

        or at the chat command prompt:

                /LI ADD <ipaddress>:<tcp_port> <peer_alias>
                /LI ADD 67.69.96.23:3600 KDRCHT
     

        Links with RoundTable/BPQ Peers
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Links with RoundTable/BPQ chat servers are defined similarly
        to the XRchat NetRom case, except that the peer callsigns
        must be prefixed with a '+', for example

                CHATLINKS=+XE1FH-11,+N1FGR
        or      /LI ADD +XE1FH-11

        The '+' is very important - it tells XRouter to use
        RoundTable protocol instead of XRchat protocol!


        Links with Tampa Ping-Pong Peers
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Links with Tampa Ping-Pong converse servers are specified in
        XROUTER.CFG as follows. Note the <peername> is prefixed with
        a '*' to distinguish it        from an XRchat TCP entry:

                CHATLINKS=<ip_address>:<tcp_port> *<peername>
        e.g.    CHATLINKS=80.195.22.67:3601 *brmcht

        Alternatively, use the /LINK ADD command

                /LI ADD <ipaddress>:<tcp_port> *<peername> 
        e.g.    /LI ADD 80.195.22.67:3601 *brmcht

      
FILES
        The chat server stores user accounts in the CHAT subdirectory,
        and reads its HELP files from CHAT/HELP/ subdirectory.      

        If transaction logging has been enabled by a non-zero CHATLOG
        directive in XROUTER.CFG, chat server activity is recorded in
        the LOG subdirectory.  If the "use single logfile" option is
        enabled, everything is logged to file CHATSERV.LOG, otherwise
        it is logged to dialy logfiles with names in the form
        yymmddCH.LOG, where yymmdd are the year, month and day.

AVAILABILITY
        The chat server is available to all users. It is also
        available via the HTTP and MQTT interfaces.

SEE ALSO
        CHAT(1)        -- CHAT command.
        CHATCMDS(1)    -- Chat server commands.
        CHATALIAS(7)   -- Chat Server Alias.
        CHATCALL(7)    -- Chat Server Callsign.
        CHAT-SVC(9)    -- NetRomX Chat Service.
        CHATPORT(7)    -- TCP Port for Chat Server.
        MQTT-CHAT(9)   -- MQTT Interface to Chat Server.
        XROUTER.CFG(8) -- Main Configuration File.

CHAT-SRV(9)                 END OF DOCUMENT
