;*************************** Max Width *******************************
CHATALIAS(7)           XROUTER REFERENCE MANUAL              24/9/2023

NAME
        CHATALIAS -- Alias for Chat Server.

SYNOPSIS
        CHATALIAS=<alias>

DESCRIPTION
        CHATALIAS is a directive that can be used in XROUTER.CFG,
        both "globally" and within PORT definition blocks.

        It specifies an "alias", i.e. a sort of memorable alternative
        "callsign" for the chat server, e.g. "IOWCHT" (Isle of Wight
        Chat). This can be used interchangeably with the CHATCALL;
        i.e. the chat server will respond to either.

        The <alias> is a string of up to 6 uppercase ASCII characters
        and numbers. It is suggested that it should end with "CHT",
        and begin with something geographically relevant, e.g. BHMCHT
        for Birmingham, LDSCHT for Leeds etc., so it can be easily
        identified in node tables.

        If used "globally", it specifies the "primary" chat alias,
        used for AX25, NetRom and TCP operations. This is also the
        chat server's "identity", as displayed on chat messages.

        Any PORTs declared further down XROUTER.CFG "inherit" this
        alias for AX25 Layer 2 chat server operation on that port,
        UNLESS overridden by the use of CHATALIAS within that PORT's
        definition block.

        If CHATALIAS is used within a PORT definition block, it
        replaces the "global" chat alias for that port only.

EXAMPLE
        CHATALIAS=IOWCHT

CAVEATS
        Omitting the global CHATALIAS, or setting it IDENTICAL to
        NODEALIAS disables chat server connectivity, but the server
        can still be used "standalone" via the CHAT command.

SEE ALSO
        CHAT(1)        -- Start Chat Session.
        CHAT-SRV(9)    -- Chat Server.
        CHATCALL(7)    -- Chat Server Callsign.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

CHATALIAS(7)                  END OF DOCUMENT
