;*************************** Max Width *******************************
CHATCALL(7)            XROUTER REFERENCE MANUAL              24/9/2023

NAME
        CHATCALL -- Callsign for Chat Server.

SYNOPSIS
        CHATCALL=<callsign>

DESCRIPTION
        CHATCALL is a directive that can be used in XROUTER.CFG,
        both "globally" and within PORT definition blocks.

        It specifies the AX25/NetRom callsign for the chat server.
        This can be used interchangeably with the CHATALIAS; i.e. the
        chat server will respond to either.

        If used "globally", it specifies the "primary" chat callsign,
        used for AX25 and NetRom operations. This can be the same as
        NODECALL, but must use a different SSID. A SSID of -8 is the
        de-facto standard for XRchat systems.

        Any PORTs declared further down XROUTER.CFG "inherit" this
        callsign for AX25 Layer 2 chat server operation on that port,
        UNLESS overridden by the use of CHATCALL within that PORT's
        definition block.

        If CHATCALL is used within a PORT definition block, it
        replaces the "global" chat callsign for that port only.

EXAMPLE
        CHATCALL=G8PZT-8

CAVEATS
        Omitting the global CHATCALL, or setting it IDENTICAL to
        NODECALL (including the SSID) disables chat server
        connectivity, but the server can still be used "standalone"
        via the CHAT command.

SEE ALSO
        CHAT(1)        -- Start Chat Session.
        CHAT-SRV(9)    -- Chat Server.
        CHATALIAS(7)   -- Chat Server Alias.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

CHATCALL(7)                  END OF DOCUMENT
