CHATCMD2(1)          XROUTER REFERENCE MANUAL                23/1/2013

CHAT SERVER COMMANDS (M-Z)
==========================

The following commands are available within the chat server only.

/?        /ALERT    /ANSI     /BELL     /BYE      /CHANNEL  /ECHO
/EXIT     /HEADERLN /HELP     /JOIN     /KEEPALIV /KM       /KNOWN
/LEAVE    /LINKS    /MSG      /NAME     /NODES    /PERSONAL /PORTS
/QTH      /QUIT     /RECENT   /RM       /STAMP    /TOPIC    /USER
/VERBOSE  /VERSION  /WHO


CHAT SERVER COMMANDS IN DETAIL - continued
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

/MSG --- Send a short message to a channel or a single user.

         Syntax: /M[sg] <channel | callsign | callsign@server> <text>

         The /Msg command is used to send a short message (70 chars 
         max.) to any specified channel or single user.  You may for 
         example use this command to direct a message to a channel you 
         are monitoring, but not actually logged to.

         If you direct a message to a specific user, he may be on this 
         or any other chat server.  The private nature of the message 
         will be indicated to the recipient by asterisks around the 
         sender's call, e.g. <*g8pzt@kdchat*> (Paula): Meet me on 
         channel 69.

         If the target user's server is specified in the command, and
         the user isn't currently logged on, the message will be
         stored until he logs on. e.g. "/M g6yak@kdrcht Give me a
         shout on 'KD when you read this.."

         Examples: /M 32 Hello People
                   /M g6yak Meet me on channel 69
                   /M g6yak@kdrcht See u on KD later

         The first form sends "Hello People" to all the users of 
         channel 32, and the second form sends a private msg to g6yak 
         only. Providing G6YAK is logged on to any chat server, the 
         message will find him. The third form sends a private message
         to G6YAK on the KDRCHT server. If G6YAK is not currently
         logged on, the message will be stored for him.

         Note: As with all things Packet, the term "private" is 
         relative, as nothing is truly private when it is broadcast!


/NAME -- Set name.

         Syntax:  /N[ame] <your name> [channel]

         The /NAME command sets the user's name, which will be 
         displayed on the user list and prefixed to everything he 
         sends to others.

         Users are not allowed to join any channels until they have 
         supplied a name (12 chars max), so it acts as a "log on" 
         command.  The name need be supplied only at the initial 
         logon, and may be changed as the user wishes.

         On the first use of this command, the user may optionally 
         specify a channel to join instead of the default (channel 0).

         TCP/IP users must first use the /USER command (see below) to 
         enter their callsign.

         Examples: /N Paula       Set name to "Paula"
                   /N Paula 23    Set name and join channel 23


/NODES - Display RoundTable nodes

         Syntax: /NO[des]

         The /NODES command displays a detailed list of the known
         RoundTable / BPQchat nodes. This command currently duplicates
         the function of the /K command.

         The display includes the node call and alias, plus the
         software version used at that node.


/PERSONAL - Display / change personal description.

         Syntax: /P[ersonal] [text | @]

         The /PERSONAL command is used to display or change the user's 
         personal description.  This is a short text of up to 32 
         characters, which is displayed on the user list.  It may 
         typically contain the user's home town and "brag" 
         information.  If the user logs onto any "public" channels 
         (i.e. those above channel 255), this information will appear 
         on the user lists of all other chat servers.

         If used without arguments, the /PERSONAL command displays the 
         user's current text.  

         If the argument is "@", the existing text is removed.

         Examples: /P                        - Displays current text
                   /P Kidderminster, sysop   - Set new text.
                   /P @                      - Clear previous text.


/QTH --- Display / set QTH.

         Syntax: /Q[th] [your-qth]

         The /QTH command is used to set your QTH. QTH is not
         currently required by the XRchat system, but is mandatory
         if you log in to room 101 (RoundTable/BPQ chat).

         Examples: /Q                    - Displays current QTH.
                   /Q Weston Super Mare  - Sets new QTH.

         Note: QTH may include spaces, and can be up to 64 characters.


/QUIT -- Exit the chat server.

         Syntax: /QU[it]

         The /QUIT command, which may be shortened to /Q, disconnects 
         the user from the chat server, and informs everyone that he's 
         left.  There is no need for the user to /leave any logged 
         channels before issuing this command.

         If the user accessed the server via the router's CHAT
         command, he will be returned to the router's main command 
         prompt, otherwise he will be completely disconnected.

         The /BYE and /EXIT commands also perform this function.


/RECENT - Display Recent Messages

         Syntax:  /R[ecent] [channel]

         The /RECENT command displays the last 10 messages received
         in the last 24 hours.

         Examples:  /RECENT  - Show recent messages from all channels
                    /RE 1234 - Recent messages from channel 1234

         The purpose of this command is to display messages that you
         might have missed while you weren't connected, allowing you
         to conduct non-real-time conversations.

         Messages currently expire after 24 hours.


/RM ---- ReadMail

         Syntax: /RM

         The /RM (ReadMail) command is used to read any personal
         messages that were left for the user while he was offline.

         If someone sends a certain type of personal chat message to
         a user while he isn't logged in, that message is stored
         on the chat server, and he is notified when he next logs
         in.  He may then use the /RM command to read the messages.

         Messages are not deleted after they are read. The /KM
         (KillMail) is used to delete unwanted messages.


/STAMP - Controls timestamping of message texts.

         Syntax:  /S[TAMP] [on | off]

         With stamp ON (default) each mesage is timestamped in the 
         following style, designed to be readable both by humans and 
         by client software:

         [1234] 09:35 {21:33} <ZL2BAU@BAUCHT> (Peter): Hello folks

         The first field is the channel number.  This may seem
         pointless, but you will soon appreciate it if you are logged 
         to more than one channel!

         The second field is the chatserver's timestamp, i.e. the 
         local time the message was received at, and redistributed by, 
         the server.  This is useful if you are away from the screen 
         for a while, or are logging the activity to disk.

         The third field is the originating server's timestamp, i.e. 
         the local time at which the message was entered into the 
         system.  With servers linked across different timezones, the 
         two timestamps may differ by up to 12 hours.  Personally I 
         find it useful to know what the other user's local time is, 
         because it helps put their comments into perspective.  The 
         timestamps can also highlight propagation delays.

         The fourth field consists of the sender's callsign and the
         "alias" of the originating server.  Users may (and often do) 
         log onto more than one server, often at the same time.

         The fifth field is the user's name.

         Those who are used to chatting on the Ping-Pong system seem 
         to be unable to cope with anything which is different, so 
         with STAMP OFF the header information is abbreviated in the 
         Ping-Pong style as follows:

         <g8pzt:Paula>: Test


/TOPIC - Display / Change channel topic.

         Syntax: /T[opic] [channel] [text | @]

         Every channel has an optional topic, and the /TOPIC command 
         can be used to display the existing topic or change it.  The 
         topic can be up to 12 characters, and is displayed on the 
         /Who list.

         Examples: /T                        - Show current ch. topic
                   /T 32                     - Show channel 32 topic
                   /T 32 TCP/IP discussion   - Set topic for ch. 32
                   /T @                      - Clear topic.


/USER -- TCP/IP logon.

         Syntax:  /U[ser] <callsign> [name]

         The /USER command is available only to TCP/IP users.  It sets 
         the user's callsign (and optionally his name), which will be
         displayed on the user list and prefixed to everything he 
         sends to others.

         The user will not be able to join the conference without 
         supplying both callsign (9 chars max) and name (12 chars 
         max), but if the name is omitted from this command he may 
         enter it in the normal way with the /Name command.

         Examples: /U g8pzt          - Set callsign to "g8pzt".
                   /U g8pzt Paula    - Set callsign and name.


/USERS - Display RoundTable/BPQChat users.

         Syntax:  /U[sers]

         The /USERS command is available only when logged to the
         RoundTable/BPQChat channel (room 101). It displays all the
         users currently logged into the RoundTable/BPQ chat network.

         For each user, the callsign, name and QTH are displayed,
         together with the alias of the server where they are logged
         in.


/VERBOSE - Enable / disable Verbose alerts

         Syntax: /VERB[ose] [on | off]

         Controls whether or not the user gets advised of things
         happening on other channels.  e.g. if sysop is monitoring
         channel 1234 with verbose on, she would be advised whenever
         anyone logs on or off any channel.

         This is primarily of use to GUI clients, allowing them to
         build and maintain their own lists of who's on what channel.


/VERSION - Display chat server version.

         Syntax: /V[ersion]

         The /VERSION command displays the chat server version, author
         and compilation date.  Please quote it if reporting bugs.


/WHO --- List channels and users.

         Syntax: /W[ho] [*]

         The /WHO command lists who is logged onto the chat server,
         and what channels they are on.

         If no arguments are supplied, the active channels are listed,
         along with the callsigns of their users.

         If an asterisk is supplied as the argument, each user is
         displayed in more detail.  The display would typically show
         the user's callsign, name, personal text and logon date/time.

         Examples:  /W     Lists channels & users in brief format
                    /W *   Lists users in detail


SEE ALSO
        CHAT(1)     -- Start a chat session
        CHATCMDS(1) -- Chat server commands A-M

CHATCMD2(1)                    END OF DOCUMENT
