CHATCMDS(1)           XROUTER REFERENCE MANUAL               23/1/2013

CHAT SERVER COMMANDS (A-L)
==========================

The following commands are available within the chat server only.

/?        /ALERT    /ANSI     /BELL     /BYE      /CHANNEL  /ECHO
/EXIT     /HEADERLN /HELP     /JOIN     /KEEPALIV /KM       /KNOWN
/LEAVE    /LINKS    /MSG      /NAME     /NODES    /PERSONAL /PORTS
/QTH      /QUIT     /RECENT   /RM       /STAMP    /TOPIC    /USER
/VERBOSE  /VERSION  /WHO


CHAT SERVER COMMANDS IN DETAIL
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

/? ----- Display commands / syntax help.

         Syntax: /? [cmd]

         When used without arguments, the /? command lists the 
         available commands.  The syntax for any of the commands thus 
         listed may be shown by specifying the command as an argument 
         to the /? command.

         Examples:  /?          List available commands.
                    /? /who     Display syntax for the /WHO command.


/ALERT - Enable / Disable channel join/leave alerts

         Syntax: /A[lert] [ON | OFF]

         Examples: /A             Reports current on / off state.
                   /ALERT ON      Turns alerts on.

         If ALERT is ON, the server sends you a notification every
         time someone joins or leaves the channel (room) you are in.
         This is the default setting.


/ANSI -- Enable / Disable ANSI colour

         Syntax:  /A[nsi] [on | off]

         The /ANSI command is used to enable or disable the use of
         ANSI colour.  In order to make use of this feature, callers 
         must be using an ansi-compatible terminal.  When enabled, 
         each user's messages are shown in a different colour making 
         it easier to follow threads of conversation. 

         Typing /ANSI by itself displays the current setting.


/BELL -- Display / Set activity bell

         Syntax: /BE[ll] [0-3]

         The /BELL command controls which events are signalled by an 
         audible warning.  The warning consists of a bell character 
         (ascii 7) within the text.  In order to use this feature, 
         your terminal software must respond to bell characters.

         Arguments to the /BELL command are as follows:

               0     No bells (default setting)
               1     Informative messages from chat server only
               2     Text entered by other chatters only
               3     All events.


/BYE --- Exit the chat server.

         Syntax: /B[ye]

         The /BYE command, which may be shortened to /B, disconnects 
         the user from the chat server, and informs everyone that he's 
         left.  There is no need for the user to /leave any logged 
         channels before issuing this command.

         If the user accessed the server via the router's CHAT 
         command, he will be returned to the router's main command 
         prompt, otherwise he will be completely disconnected.

         The /EXIT and /QUIT commands also perform this function.


/CHANNEL - Display / Change logged channel(s).

         Syntax: /C[hannel] [number] | DEFAULT [number]

         The /CHANNEL command displays / changes the channel(s) the 
         user is logged to.  When no argument is supplied, the logged 
         channel(s) is / are displayed.  If a valid numeric argument 
         is supplied, the user is logged to the specified channel.

         Examples: /C               Displays your current channel(s)
                   /C 22            Change to channel 22
                   /C default 1234  Default to channel 1234.

         When a new channel is selected, the user remains logged to 
         any previous channels, (so he can "monitor" several channels 
         at once) but any subsequent text he sends will go to the new 
         channel (unless targeted otherwise).

         Channels 1 to 255 (except 101) are "local" to this server.
         Channel 101 links with RoundTable/BPQchat, if enabled.
         Channels 256 to 32767 may be linked to other Xrouter chat
         servers.
         If a connection with the "Tampa Ping-Pong converse"
         system has been enabled, channels 0 to -32767 correspond to
         channels 0 to 32767 on Ping-Pong, otherwise they can be used
         as local channels.

         The default channel at log-on is 1000. You may check or
         change this using the "/channel default" form of this command. 

         The /JOIN command has a similar function, and /LEAVE is used 
         to de-select unwanted channels.


/ECHO -- Control host echo

         Syntax: /EC[ho]

         The /ECHO command toggles host echo on and off.  The default 
         setting is ON, i.e. the user receives a copy of any text he 
         sends to the channel.

         Although host echo slightly increases bandwidth usage, it 
         helps to put the user's text into temporal context amongst 
         the other channel texts, especially when there is latency on 
         the links.  The user can more easily spot mistakes such as an 
         incorrectly entered name or callsign.


/EXIT -- Exit the chat server.

         Syntax: /E[xit]

         The /EXIT command, which may be shortened to /E, disconnects 
         the user from the chat server, and informs everyone that he's 
         left.  There is no need for the user to /leave any logged 
         channels before issuing this command.

         If the user accessed the server via the router's CHAT 
         command, he will be returned to the router's main command 
         prompt, otherwise he will be completely disconnected.

         The /BYE and /QUIT commands also perform this function.


/HEADERLN Controls display format

         Syntax: /HEA[derln] [on | off]

         The /HEADERLN command controls whether or not the "header"
         and text of messages are displayed on the same line.

         If the setting is OFF (default), the header and text are 
         displayed on the same line.  This leads to a more compact 
         display, especially when the texts are short.

         If the setting is ON, headers and text are displayed on 
         separate lines. 


/HELP -- Obtain help.

         Syntax: /HELP [topic]

         When used without arguments, the /HELP command gives brief 
         instruction on how to access various levels of help.

         If a topic is specified, detailed help for that topic (if 
         available) is displayed.  The topic may be a command name, or 
         any other chat server related topic.  A list of the available 
         help topics can be obtained by specifying "*" as a topic.

         Examples:  /H          Display general instructions.
                    /H *        List available help topics.
                    /H /who     Display help for /WHO command.

         Note:  When using /H to display help for a command, the         
         leading slash for that command may be omitted.  Thus         
         "/H /who" and "/H who" are equally permissible.


/JOIN -- Join (log onto) a channel.

         Syntax: /J[oin] <channel>

         The /JOIN command logs the user to a channel, and performs a 
         similar function to the /CHANNEL command.

         When a new channel is selected, the user remains logged to 
         any previous channels, (so he can "monitor" several channels 
         at once) but any subsequent text he sends will go to the new 
         channel (unless targeted otherwise).  (Unwanted channels may 
         be de-selected using the complementary /LEAVE command.)

         Example:  /J 22   Join channel 22

         See /CHANNELS for a description of the channels.

/KEEPALIVE - Enables / disables link "keep alive" messages.

         Syntax: /KE[epalive] [ON | OFF]

         Examples: /K             Reports current on / off state.
                   /KE ON         Turns keepalives on.

         There is no time-out on connections with XRchat, BUT if you
         are connected for long periods with no activity, some part
         of the link you are using may time out.  For example, a NAT
         entry may time out, or an inter-node link may disconnect.
         Keep alive messages are intended to keep such links open,
         by sending a short text every 10 minutes.

         If you are monitoring for long periods, the keepalives may
         become irritating, so don't enable them unless you need them.

/KM ---- Kill Mail

         Syntax: /KM

         The /KM (KillMail) command is used to delete personal
         messages after you have finished with them.

         If someone sends you a certain type of personal chat message
         while you are not logged in, that message is stored at your
         server, and you will be notified when you next log in. You
         may then use the /RM command to read the messages, and the
         /KM command to delete them afterwards.


/KNOWN - Known Nodes

         Syntax: /K[nown]

         The /KNOWN command, which may be shortened to /K, is used
         to display a detailed list of the known RoundTable nodes.
         The display includes the node call and alias, plus the
         software version used at that node.


/LEAVE - Leave (log off) a channel.

         Syntax: /L[eave] <channel>

         The /LEAVE command logs the user off the specified channel.  
         When a user joins a channel, he remains logged to any 
         previous channels, so this command allows him to de-select 
         unwanted channels.

         Example:  /L 22   - Leave channel 22


/LINKS - Display / Change peer links

         Syntax: /LI[nks] [*]
                 /LI[nks] ADD <peercall>
                 /LI[nks] ADD <peername> <ip_addr>:<tcp_port>
                 /LI[nks] DROP <callsign | peername>

         The /LINKS command shows the status of the links with other 
         chat servers, and allows sysops to add and drop links without 
         rebooting Xrouter.

         "/LI[nks]" by itself displays a list of the links with users
         and other severs. The fields are as follows:

         Callsign   - Callsign of user or peer server.
         Type       - Connection type (L2, L4, TCP etc).
         Connected  - Date / time when connection started.
         Last-heard - Date / time when last data rcvd.
         Sent       - No. of messages sent to this peer.
         Unsent     - No. of messages dropped due to congested link.
         Rcvd       - No. of messages received from this peer.
         Lost       - No. of messages not rcvd due to link congestion.
         Sta        - Connection state (1=opening, 2=open, 3=closing)
         TXE        - Indicates TX empty, i.e. nothing queued.

         "/LI[nks] *" additionally displays a list of the defined
         chat links, whether they are currently connected or not.

         "/LI ADD" adds a peer server to the list, and has two forms,
         one for NetRom links and one for TCP/IP links.

         In the Netrom case, <peercall> is the netrom callsign (not 
         alias) of the peer server, and it must exist in Xrouter's 
         nodes table otherwise the link will not be opened.  If you 
         have trouble with peers dropping in and out of the nodes 
         table, create a "locked" node entry.

         In order to define a link with a RoundTable/BPQ chat server
         the callsign must be prefixed with a '+' e.g. "+XE1FH-11".
         The link will not be allowed unless both callsign and alias
         are in the nodes table.

         In the TCP/IP case, <peername> is the server ID of a Tampa 
         Ping-Pong server, <ip_addr> is its IP address, and <tcp_port> 
         is the TCP port number of the server.

         Examples:  /LI ADD +G1SSL-11
                    /LI DROP G8NTU-8
                    /LI ADD brmcht 80.195.22.37:3601


SEE ALSO
        CHAT(1) -- Start a chat session
        CHATCMD2(1) -- Chat Commands in detail (M-Z)

CHATCMDS(1)                    END OF DOCUMENT
