;***********************|****** Max Width *****|*********************|
CHATPORT(7)             XROUTER REFERENCE MANUAL             27/9/2023

NAME
        CHATPORT -- TCP Port for CHAT Server.

SYNOPSIS
        CHATPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        CHATPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        by the CHAT server. If not present, the default is 3600.

        The CHAT server, allows groups of users to hold live
        multi-way conversations without having to manage several TNC
        streams at once.

        The CHAT server is also available as NetRomX service 8, plus
        via CHATCALL/CHATALIAS and the CHAT command.

OPTIONS
        If a single argument is supplied, e.g. "CHATPORT=3600", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "CHATPORT=3600 3601", the
        first argument applies to the XRouter stack and the second to
        the host system's stack. The numbers must be separated by
        whitespace

        Setting CHATPORT to zero on a stack prevents TCP connections
        to the chat server via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        CHAT-SRV(9)    -- CHAT Server.
        CHAT-SVC(9)    -- NetRomX CHAT Service.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

CHATPORT(7)           END OF DOCUMENT
