COLS(7)                 XROUTER REFERENCE MANUAL            19/10/2023

NAME
        COLS -- Set Display Width (deprecated).

SYNOPSIS
        COLS=n (n = 40-120)

DESCRIPTION
        COLS is an optional configuration directive, used only in the
        "global" section of XROUTER.CFG. It sets the display width
        in columns or characters of text.

        The default display width for XRouter is 80 columns, which is
        a legacy from the 80x25 DOS days. With XR32 running in a
        Windows "command" window, this setting allows the use of
        retro "full screen" mode, using the ALT-RETURN key
        combination.

        As XRouter, like most packet systems, is intended for a
        display width of 80 columns, all its responses are designed
        to fit within that width. The only thing that might exceed 80
        columns is monitored traffic, which simply wraps.

        So increasing the display width merely reduces the amount of
        wrapping on monitored data, whilst reducing the width may
        cause wrapping and corruption of displays such as the status
        bar, nodes tables, table headings and so on.

        Whereas Windows resizes the containing window to fit the
        dimensions specified by XRouter, Linux does not. On Linux,
        the width of the containing terminal window must be equal to
        of greater than COLS, otherwise the display is corrupted

        *** Therefore the use of COLS is strongly deprecated ***

        If you really *must* fiddle, use the COLS directive near the
        start of XROUTER.CFG, before any CONSOLE definitions.  As an
        example, for a 90-column display use COLS=90.

CAVEATS
        If you set COLS less than 80, the bottom menu bar will be
        corrupt or blank. If you set it less than 79, fields on the
        Route monitor window will wrap. If you set it less than 76,
        the top status bar disappears. If you set it less than 30,
        XRouter will segfault when you exit.

        If you set COLS more than 80, you cannot use "full screen"
        mode on Windows.

SEE ALSO
        ROWS(7)        -- Set Display Height.
        XROUTER.CFG(8) -- Main Configuration File.

COLS(7)                     END OF DOCUMENT
