CONNECT(1)              XROUTER REFERENCE MANUAL              4/9/2023

COMMAND
        CONNECT -- Make an outgoing AX25 connection

SYNOPSIS
        C[onnect] [port] <call> [V(ia) digi[,digi...]] [svcnum] [S]

DESCRIPTION
        The CONNECT command, which may be abbreviated to "C", 
        instructs XRouter to make an outgoing (downlink) AX25 level 
        2 or 4 connection with another system.

        If the target is a known node (i.e. one which is in the nodes 
        table) a port number is not required, and will be ignored if 
        supplied.  The router will attempt to make a NetRom level 4 
        connection with the target, using information from the
        routing tables.

        To override the above mechanism and "force" a level 2
        connection with an immediately adjacent node, either of the
        following methods can be used:
        
        (a) by appending an arbitrary SSID to the target's ALIAS and
            specifying a port number if required, e.g. "C 4 MLVN-1".

        (b) by prefixing the target call with an exclamation mark,
            and specifying a port if required, e.g. "C 4 !G4FPV".

        If the target is NOT a known node, XRouter will attempt to 
        make a level 2 connection.  On multi-port systems, a port 
        number must be specified.

        The "V" (via) parameter allows up to 7 digipeaters to be 
        specified, e.g.:  "C 3 G6YAK V G8NTU G8EPR"

        The "S" (stay) parameter, e.g. "C <nodecall> S" causes the 
        uplink session to stay connected when the downlink session to 
        the target node is terminated.

        The [svcnum] parameter specifies the "service number" on the
        target system. This is only understood by XRouter nodes at
        present. It causes a "NetRomX" (XRouter extended netrom)
        connection to one of 65535 possible "services" hosted by the
        target system. The service numbers are "standard", like the
        "well known" port numbers in TCP and UDP. For example,
        service 0 is always the node's command line, service 1 is
        always an "information server", service 2 is always a PMS,
        service 8 is always a chat server, and so on. See the
        SERVICES manual page for a full list.

EXAMPLES
        C GLOS      - Level 4 connect to GLOS:GB7GH node
        C 4 MLVN-1  - Forced level 2 connect to MLVN:G4FPV node 
        C 3 G6YAK   - Level 2 connect to non-node G6YAK on port 3
        C KIDDER 8  - L4 connect to service 8 (chat) on KIDDER node
        C G8PZT 1 S - L4 connect to service 1, then stay connected

LIMITATIONS
        If more than 7 digipeaters are specified, only the first 7 
        will be used.

AVAILABILITY
        This command is available to everyone, with the exception of
        "guest" users, i.e. those who have accessed XRouter via the
        public internet without supplying a password.

SEE ALSO
        CX(1)       -- Connect using Extended Ax25
        SERVICES(9) -- Standard Service Numbers
        TELNET(1)   -- Initiate a TELNET downlink
        TTYLINK(1)  -- Initiate a TTYLINK downlink

CONNECT(1)                        END OF DOCUMENT
