;***********************|****|* Max Width *|***|*********************|
CONSOLES(6)             XROUTER REFERENCE MANUAL             26/9/2023

NAME
        CONSOLES -- About XRouter Conoles.

INTRODUCTION
        In this context "consoles" are one of the types of "window"
        in the XRouter display. They allow the sysop to interact with
        XRouter, for example to trace traffic, or make connections.

        Each console is fully independent, and you may have up to
        five of them. The first one is usually window number 8. Use
        the left and right "arrow" keys to navigate the windows.

CONSOLE LAYOUT
        The console display starts on the line below the grey XRouter
        status/menu bar. Each console has the following format:

        There is a single-line "status bar" at the top and a single
        line "menu bar" at the bottom. By default, these have a cyan
        background).

        Immediately above the menu bar is a single "command entry"
        line, with dark blue background and yellow text.

        The remaining central section is where monitored and received
        information is displayed, and this section is ANSI colour
        compatible.

        The console status bar shows the console number, the console
        callsign, and the connection state of that console. The
        bottom "menu bar" displays a context-sensitive menu for that
        console.

        The text and background colours of the various sections are
        fully configurable. The default settings were chosen to be
        ergonomic, but may not be to your taste, and can therefore
        be overridden by entries in the global section of
        XROUTER.CFG. The defaults can be further modified for
        individual consoles by adding console definition blocks.

        You may specify a different callsign for each console (used
        when making outgoing connections), or use the same callsign
        for each one.

        For details of how to configure the various console colours
        etc. see the console configuration page.

CONSOLE KEYS
        The following "special" keys are available when a console is
        displayed:

           <F1>                Display console help window.
           <F2>                Toggle monitoring on/off (MON).
           <F3>                Select port(s) to monitor. (MPORT)
           <F4>                Select monitored protocols. (MMASK)
           <F5>                Toggle disk capture on/off.
           <ESC>               Cancel operation / Disconnect.
           L/R arrow           Select previous / next console.
           U/D arrow           Scroll back/forward by one line.
           <PgUp>/<PgDn>       Scroll back/forward by one page.
           <End>               End scrollback.
           <Ctrl-LeftArrow>    Previous command in history.
           <Ctrl-rightArrow>   Next command in history.
           <Alt> / ALT-M       Open menu.
           <Alt-C>             Clear screen.
           <Alt-X>             Exit program.

        <F1> - Help

        Pressing <F1> pops up a dialog with the above information on
        it. The <ESC> key closes that dialog when you've finished
        with it.

        The contents of the help window are context-sensitive, i.e.
        they vary according to what you were doing when you pressed
        the <F1> key.

        <F2> - MON - Monitoring

        The <F2> key provides a quick way to toggle monitoring
        (protocol tracing) on and off, and is a shortcut for the
        MON ON|OFF commands.

        <F3> - MPORT - "Monitor port"

        The F3 key selects the port(s) to be monitored (traced), and
        is a shortcut for the MPORT command.

        Upon pressing this key you are invited to enter a number or
        string of numbers representing the combination of ports to
        monitor. If you press <F1> at this point a pop-up help
        window will show you the following information:

        To select port(s) to monitor, add together the following hex
        values:

            Port HEX    Port HEX     Port HEX     Port HEX
            ------------------------------------------------------
             0    1      8   100     16  10000    24   1000000
             1    2      9   200     17  20000    25   2000000
             2    4     10   400     18  40000    26   4000000
             3    8     11   800     19  80000    27   8000000
             4   10     12  1000     20 100000    28  10000000
             5   20     13  2000     21 200000    29  20000000
             6   40     14  4000     22 400000    30  40000000
             7   80     15  8000     23 800000    31  80000000

        e.g. #12 will monitor ports 4 and 1.

        Alternatively you may enter a single decimal port number,
        or a combination of ports separated by "+" e.g. "1+5+23".

        You may cancel the operation by pressing the <ESC> KEY.

        <F4> - Monitor Mask

        The <F4> key invites you to enter the "monitor mask" (aka
        trace mask), i.e. the protocols you wish to monitor.
        Pressing <F1> at this point pops up a help window with the
        following information:

             0001 - Incoming frames          0100 - ICMP
             0002 - Outgoing frames          0200 - TCP
             0004 - AX25 layer 2             0400 - KISS
             0008 - AX25 info frames         0800 - SLIP
             0010 - AX25 layer 3             1000 - PASSALL
             0020 - AX25 layer 4             2000 - Hex Dump
             0040 - IP frames
             0080 - ARP frames

        To select protocols, add together the desired hex flags from
        the above list. For example 0201 will show incoming TCP
        segments only, while 0241 will show the underlying IP
        datagrams as well. The default setting is 03FF, which shows
        all incoming and outgoing traffic from AX25 layer 2 upwards.

        The MMASK command has the same function.

        <F5> - Disk capture

        The <F5> key toggles disk capture on and off, and is a
        shortcut for the CAP[TURE] command.

        When capture is enabled, anything which is displayed in the
        central window of an XRouter console is also written to disk.
        This includes session activity and TRACE'd data. You can
        make it more specific using <F4> (MMASK) and <F3> (MPORT).

        Whereas the screen display is filtered to prevent it being
        garbled by binary data, the capture is pure binary, so it is
        useful for diagnostics.

        There is a seperate capture file for each XRouter "console",
        named CAPTUREnn.TXT where nn represents the console number
        (01 to 05). The capture files are created in the XRouter
        working directory. Although they have the extension ".TXT"
        to enable them to be easily opened with a text editor, they
        may somtimes contain characters which simple text editors
        can't display.

        Capture is fully independent on each console, and consoles
        may be captured concurrently. Switching between consoles, or
        scrolling consoles back, does not affect the capture.

        <ESC> - Cancel / Disconnect

        The <ESC> key "backtracks" if you have pressed <F1>, <F3> or
        <F4>. It can also be used to immediately disconnect a
        console session.

SELECTING CONSOLES
        The left and right "arrow" keys are used to scroll through
        the various XRouter windows. If you have enabled any
        consoles, they can be selected using this method.

        Note that when you reach the last window, it wraps back to
        the first and vice versa.

        Alternatively you may jump directly to a console by tapping
        Alt-V (view) followed by the console number, or you may
        select it from the window menu. The console numbers are
        shown on their top status bars.

WINDOW MENU
        On XRPi/XRLin, pressing <ALT> and <M> together temporarily
        replaces the console status bar with a grey "menu bar". On
        XRWin the <ALT> key by itself performs the same function.

        The menu bar currently has (F)ile (V)iew and (H)elp options,
        which can be navigated using the arrow keys, and actioned
        using the <RETURN> key.

        One character of each menu item is highlighted in red,
        indicating that it is a "hot key". Pressing the highlighted
        key causes that menu item to be actioned. For example ALT-M
        followed by "V" takes you into the (V)iew menu, from where
        pressing the "N" key takes you to the nodes monitor window.
        Or you can simply type ALT-V followed by "N".

        Upon actioning a menu item or pressing <ESC>, the menu is
        closed and the console top status bar returns.

FILE MENU
        The (F)ile menu item (shortcut ALT-F) only has 3 options at
        present.

        "(R)eload IProutes" re-reads the contents of IPROUTES.SYS,
        in case you made any changes during run-time.

        "(S)ave Nodes" saves the current nodes and routes tables to
        the XRNODES file.

        "e(X)it program" terminates XRouter.

VIEW MENU
        The (V)iew menu currently displays at least 8 options:

        "c(L)ear Window" clears the current console window.

        "S(Y)sop Chat" jumps to window number 1. This is "always on"
        chat between XRouter sysops, using XRChat channel 1234.

        "(C)hat Monitor" jumps to window 2. This gives an overview
        of the currently active channels on the XRChat and Round
        Table (BPQ) chat systems. It also shows who is on each
        channel, and the latest chat messages.

        "(S)ession Monitor" jumps to window 3, which shows who is
        currently connected and who has recently connected to your
        system. Additionally, it displays a log of the recent
        connections and disconnections. From here you can watch and
        delete sessions.

        "(N)odes Monitor" jumps to window 4, which shows how many
        NetRom nodes your system knows about, organised by hop count.
        It also shows which routes they were heard via, and the
        "health" of each node is indicated by colour and shape of
        the characters. From here you can browse the nodes table and
        mode stats.

        "(R)outes Monitor" jumps to window 5, which shows the status
        of the "Routes" to your NetRom neighbours. You can see at a
        glance which routes are healthy and which ones might need
        attention. 

        "(X)router Status" jumps to window 6, which gives an
        overview of the health of the system, and its activities.
        This is the window that displays when XRouter starts. 

        "Sec(U)rity Nonitor" jumps to window 7, which summarises
        some of the findings of XRouter's Intrusion Detection System
        (IDS). It is a work in progress. 

        Finally the consoles can be selected by entering a console
        number

HELP MENU
        "(A)bout XRouter" displays information about the program
        version and compilation date.

        "(H)elp Topics","(M)anual Topics and "(I)nfo Topics each
        open a window which lists the available topics, with one
        topic highlighted. The highlight can be moved using the
        arrow keys, and the topic can be viewed in a scrollable
        window by hitting RETURN on the highlighted topic.

        "(C)onfig Info" displays lots of informatuion about the
        XRouter configuration in a scrollable pop-up window.

COMMAND HISTORY
        Each console remembers the last 5 commands used on that
        console. These can be selected using the <Ctrl-LeftArrow>
        and <Ctrl-RightArrow> keys, and actioned by hitting <RETURN>

REVIEW MODE
        Scrollback or "review" mode enables you to look at something
        which went off the top of the screen. Unlike DOS XRouter,
        which displayed reviewed text in yellow, the Windows and
        Linux versions preserve the original colours during review.

        The up and down "arrow" keys control scrollback, along with
        the <PgUp>, <PgDn> and <End> keys. The only indication of
        review mode is the caption on the bottom menu bar.

        The console won't receive anything else while you are in
        review mode. However, if you are capturing to file, the
        capture is not interrupted by review mode.

        The default size of the review buffer is 400 lines of text,
        which is in addition to the current page. Thus if the
        console height is 50 lines, you can review the last 9 pages
        of activity. The size of the review buffer can be altered
        using the REVIEW directive, either (for all consoles) in the
        global section of XROUTER.CFG, or (for individual consoles)
        within a CONSOLE definition block.

LANGUAGES
        Most of the texts used on the XRouter display can be replaced
        with French, Spanish or Dutch texts. This is experimental,
        and the accuracy of the translations cannot be guaranteed,
        especially in the case of abbreviations. In some cases the
        English text is not translated.

        The console language is set using the CONSOLELANG directive
        in XROUTER.CFG. If you specify this globally, it is
        inherited by all consoles. If specified in a console
        definition block, it applies to that console only. If not
        specified, the console inherits DEFAULTLANG.

        No matter what CONSOLELANG is used, SESSIONS via the console
        use the language appropriate for CONSOLECALL, which in turn
        is specified by DEFAULTLANG, or by entries in LANGS.SYS.
        Finally the LANG command can be used to change the language
        for a session, but this doesn't affect the display itself.

CONFIGURATION
        The colours and other console parameters may be specified in
        XROUTER.CFG. If they are specified in the GLOBAL section,
        the values are inherited by all consoles. Alternatively they
        may be used in CONSOLE definition blocks to override the
        global defaults on a console-by-console basis.

        The following console definition keywords are available
        (defaults shown in brackets):

        ACTIONCOLOR     Text colour for XRouter actions (yellow)
        BOTWINBGCOLOR   Background for menu bar (cyan)
        BOTWINTXTCOLOR  Text colour for menu bar (white)
        CAPTIONCOLOR    Text colour for captions/headings
        CMDWINBGCOLOR   Background color for command line (navy)
        CMDWINTXTCOLOR  Text colour for command line (yellow)
        CONSOLECALL     Callsign for console operations (nodecall)
        ECHOCOLOR       Colour for text echoed from cmd line (yellow)
        MIDWINBGCOLOR   Background for central window (black)
        MIDWINTXTCOLOR  Text colour for central window (white)
        MMASK           Flags specifying protocols to trace (3f8)
        MPORTS          Ports to monitor by default (all)
        PROMPTCOLOR     Text colour for regular prompts (lightcyan)
        REVIEW          No. of lines of scrollback (400)
        RXCOLOR         Text color for RX tracing (lime)
        TOPWINBGCOLOR   Status line background colour (cyan)
        TOPWINTXTCOLOR  Status line text colour (white)
        TXCOLOR         Text colour for TX tracing (pink)
        WARNCOLOR       Text colour for warning/error messages

        Most of these should be self explanatory. However some of
        them may need clarification:

        CONSOLECALL
        This is the callsign used for making AX25 and NetRom
        connections from the console. You can set this independently
        of NODECALL or you may set them the same (which is the
        default if you omit the directive). You may set a different
        callsign on each console, and you may at any time override a
        console callsign using the "linked as" command.

        ECHOCOLOR
        When the sysop types some text into the command line and
        presses <enter>, the text is "echoed" into the main window
        using the ECHOCOLOR. This colour is chosen by default to be
        bright, and to be different from the other colours used in
        that window, to make it easy for the sysop to differentiate
        between sent and received text.

        MMASK
        This is the "monitor mask" (aka trace mask) which determines
        which protocols are traced by default. The mask is the sum
        of the desired hex values from the following list:

             0001 - Incoming frames          0100 - ICMP
             0002 - Outgoing frames          0200 - TCP
             0004 - AX25 layer 2             0400 - KISS
             0008 - AX25 info frames         0800 - SLIP
             0010 - AX25 layer 3             1000 - PASSALL
             0020 - AX25 layer 4             2000 - Hex Dump
             0040 - IP frames
             0080 - ARP frames

        E.g. 0201 shows incoming TCP segments only, while 0241 shows
        the underlying IP datagrams as well. The default setting is
        03FF, which shows all incoming and outgoing traffic from
        AX25 layer 2 upwards. The sysop may override this at any
        time using the MMASK command or the <F4> key.

        MPORTS
        This is the combination of PORTs which will be monitored
        (traced) by default, until changed by an MPORT command or
        the <F3> key. The default is to monitor ALL ports, but you
        may wish to limit this to the main ports of interest.

        The argument is either a HEX number between 0 and FFFFFFFF,
        a list of port numbers, or the words ALL or NONE. The hex
        value is calculated by adding together the desired values
        from this table:

            Port HEX    Port HEX     Port HEX     Port HEX
            ------------------------------------------------------
             0    1      8   100     16  10000    24   1000000
             1    2      9   200     17  20000    25   2000000
             2    4     10   400     18  40000    26   4000000
             3    8     11   800     19  80000    27   8000000
             4   10     12  1000     20 100000    28  10000000
             5   20     13  2000     21 200000    29  20000000
             6   40     14  4000     22 400000    30  40000000
             7   80     15  8000     23 800000    31  80000000

        However, it is usually more convenient to specify a list of
        port numbers. These may be supplied either as a series of
        single numbers, or in one or more ranges, or as combinations
        of the two. For example: MPORTS=1,3-5,8,10-12. There must be
        no spaces in the list.

        REVIEW
        This specifies the number of lines of scrollback available
        on the console. The value is a compromise, because setting a
        large value may increase the CPU usage and/or slow down the
        scrolling. The default is 400 lines, which is 8 pages on a
        50 line console. 

        NUMCONSOLES
        The total number of consoles defaults to 3. This may be
        changed using the NUMCONSOLES=n directive in the global
        section of XROUTER.CFG, where n is a number between 0 and 5.


        CONSOLE Definition Blocks

        Console definition blocks are used to specify any
        characteristics of consoles that differ from the default. If
        all the consoles are to be identical, you can simply define
        the characteristics in the GLOBAL section of XROUTER.CFG.
        Only those characteristics that differ from the defaults
        need to be specified.

        Console definition blocks start with CONSOLE=n where n is a
        number between 1 and 5, and end with ENDCONSOLE. They may
        contain any or all of the keywords listed above (except
        NUMCONSOLES). There should be one block for each console
        that differs from the default settings.

        For example:

            CONSOLE=3
                MIDWINBGCOLOR=NAVY
                MIDWINTXTCOLOR=WHITE
                CMDWINBGCOLOR=GREEN
                CONSOLECALL=G8PZT-4
                MMASK=1f        ; AX25/Netrom only
                MPORTS=1-2      ; Monitor ports 1 and 2 only
            ENDCONSOLE
	  

SEE ALSO
        COLOURS(6)     -- XRouter Display Colours.
        CONSOLELANG(7) -- Console language
        DEFAULTLANG(7) -- Specify default language
        LANGS.SYS(8)   -- Language selection file
        XROUTER.CFG(8) -- Main Configuration File.

CONSOLES(6)                  END OF DOCUMENT
