COPY(3)                XROUTER REFERENCE MANUAL                5/9/2023

COMMAND
        COPY -- Copy file(s) (PZTDOS).

SYNOPSIS
        COPY <source> [dest]

DESCRIPTION
        The COPY command copies the file(s) specified by the pathname 
        <source> into the file(s) or directory specified by [dest].

        <source> may be 'CON', a directory, a single file, or multiple 
        files specified using wildcards, and may contain a drive and 
        path spec.  If <source> is a directory, all the files in that 
        directory will be copied.  If <source> contains wildcards, all 
        matching files will be copied.

        If <source> is 'CON' any further keyboard input is written to
        a new file specified by <dest>. The operation is terminated,
        and the file written out, upon receipt of a line containing
        only /EX or ctrl-Z. The operation can be aborted at any time
        by entering a new line containing only ctrl-A. Nothing is
        written to disk in this case.  
                
        [dest] may be a directory, a single file, or blank.  If [dest] 
        is a directory, the source file(s) are copied into it as 
        seperate files.  If [dest] is a single file, the source 
        file(s) are concatenated into it.  If [dest] is not specified, 
        the file is copied into the working directory and retains the 
        original filename.

        Pathnames may use either forward (/) or back (\) slashes.

        Pathnames that contain spaces must be enclosed in double
        quotes, e.g. "my documents/daily report"

EXAMPLES
        COPY ..\MYPROG.EXE   /progs/TESTPROG.EXE                 
        COPY "my documents/rfc793"  /reference
        COPY *.HLP  HELP.DOC
        COPY CON fred.txt

PORTABILTY
        Normal dos syntax is followed, except that concatenation using 
        the "+" operator is not supported.

AVAILABILITY
        This command is available only in PZTDOS mode, which is
        restricted to sysops only.

NOTE
        Overwrites destination files without warning.

SEE ALSO
        DOS(1)  -- Enter PZTDOS mode.
        MOVE(3) -- Move Files (PZTDOS).
        REN(3)  -- Rename files (PZTDOS)..

COPY(3)                     END OF DOCUMENT
