CRONTAB.SYS(8)          XROUTER REFERENCE MANUAL            17/10/2023

NAME
        CRONTAB.SYS -- Event Control File (optional).

DESCRIPTION
        This optional file allows XRouter commands to be executed at
        certain times of the day, week, month or year.

        A few of the possible uses would be:

        - Additional AX25 beacons.
        - Beaconning APRS objects, status, bulletins and
          announcements.
        - Adjusting Netrom / IP routing to account for part-time
          neighbours.
        - Enabling / disabling transmitters.
        - Controlling peripherals via the CTRL port.
        - Adjusting parameters to cope with diurnal propogation
          changes.
        - Loading updated ENCAP.TXT at intervals.
        - Enabling / disabling IGATE at certain times of day / week.
        - Automatic reboots / restarts / exits for batch file
          processing etc.

        When commands are executed, all responses from the command
        processor are discarded.

OPTIONS
        Commands that can be used in CRONTAB.SYS are as follows:

        ACL, APPLMASK, ARP, BCAST, BELL, BLEVEL, CAPTURE, CFLAGS,
        CTEXT, CTFLAGS, CTRL, DIAL, DHCP, DIGIFLAG, DIGIPORT, DNS,
        DUN, EXCLUDE, EXIT, FEC, FRACK, FULLDUP, GNET, ID, IDPATH,
        IDS, IDTEXT, IFACE, IPADDRESS, IPLINK, LOADNODES, LOG,
        MAXFRAME, MDIR, MFROM, MHCLEAR, MHFLAGS, MHSIZE, MINQUAL,
        MINTXQUAL, MMASK, MON, MPORT, MQTT, MTO, NAT, NETMASK,
        NODESINT, NOTIFY, ODN, PACLEN, PCAP, PEERS, PERSIST, PING,
        PIPE, PIPEFLAG, PORT, PPP, QUALITY, RESPTIME, RESTART,
        RETRIES, RIP, ROUTE, SAVENODES, SEND, SHELL, SLOTTIME, START,
        STATS, STOP, TCP, TSYNC, TXDELAY, TXOK, TXPORT, TXTAIL, UDP,
        UDPLOCAL, UDPREMOTE, UNPROTO, USERS, WAIT, WX.

FILE FORMAT
        Each entry is specified on a seperate line. Empty lines,
        and lines beginning with '#' or ';' are ignored.

        Entries have the following format:

            <min> <hour> <date> <month> <day> <command> [args]
            0-59   0-23   1-31   1-12    0-6 

        Fields must be seperated by one or more spaces or tabs.

        <command> is executed if <min> <hour> and <month> match
        the current time, and either the <date> (day of month)
        or <day> (of week) match. [args] specifies the command's
        argument(s).

        Dates / times may be specified as single numbers, multiple
        numbers, ranges, or a mixture thereof, e.g. "0-5,7,9,15-22". 
        Note there must be no spaces within the string of characters.

        Use '*' in any of the first 5 fields to signify "all".

EXAMPLES
        ; <min> <hour> <date> <month> <day> <command> [args]
        ; Every 20 mins, advertise the BBS using an APRS symbol
        ; on port 13
        0,20,40 * * * * send 13 APZ179 !5224.00N/00215.00WB GB7PZT

        ; Every Thursday at 03:05 save nodes table to an archive
        5 3 * * 4 SAVENODES PZTNODES.ACV

CRONTAB.SYS(8)               END OF DOCUMENT
