CTEXT(7)               XROUTER REFERENCE MANUAL               4/9/2023

NAME
        CTEXT -- Set "Connect Text".

SYNOPSIS
        CTEXT
        <text>
        ***
        CTEXT=<text>

DESCRIPTION
        The CTEXT directive, used in XROUTER.CFG, specifies a
        "connect text", which is a single or multi-line text that
        can be sent to a caller when they connect to XRouter.

        The directive has two possible forms, one for specifying the
        "global" CTEXT, the other for specifying a port-specific one. 

        The companion directive CTFLAGS controls which callers
        receive the text.

        If a port-specific CTEXT exists, it overrides the global
        CTEXT, on that port only.

        The GLOBAL connect text is specified in a multi-line block
        which starts with CTEXT and ends with a line containing only
        "***", like this:

             CTEXT
             This is the first line if the connection text
             This is the second line
             And so on
             ***

        A PORT connection text is specified *differently*. The
        following form is used within a PORT definition block:

             CTEXT=Single line of text, or a filename

        Upon bootup, if a port CTEXT is not specified, XRouter looks
        for the file CTEXTn.SYS, whcre n is the port number. If the
        file is found, its contents are loaded. Otherwise the global
        ctext (if any) is inherited by the port.

        In PORT blocks only, if <text> specifies a filename, the
        contents of that file are read "live" every time someone
        connects, which may be of use in EMCOMM scenarios. The
        specified file could for instance be updated by another
        program, such as an extreme weather detector.

        If the filename starts with the 5 characters "CTEXT", e.g.
        "ctext-news", that file will be read from the current
        directory. If it is a fully qualified path starting with "."
        or "/", there are no restrictions on where the file resides,
        so long as XRouter is allowed to access it. For example,
        using the CTEXT command:

            CTEXT ctext-news.txt
            CTEXT /etc/weather/latest.txt

        The CTEXT *command* allows the texts to be changed "on the
        fly".

SEE ALSO
        CTEXT(1)       -- Display / Set Connection Text.
        CTFLAGS(1)     -- Display / Set Connection Text Flags
        CTFLAGS(7)     -- Connection Text Control Flags.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

CTEXT(7)                 END OF DOCUMENT
