CTEXT(1)              XROUTER REFERENCE MANUAL               4/9/2023

COMMAND
        CTEXT -- Display or Set Port "Connect Text".

SYNOPSIS
        CT[ext] <port> [cmd [text]]

OPTIONS
        CTEXT <port>            - Displays current text

        CTEXT <port> ADD <text> - Appends a line of text

        CTEXT <port> CLEAR      - Clears the whole ctext

        CTEXT <port> LOAD       - Loads ctext from CTTEXTn.SYS

        CTEXT <port> NEW <text> - Replaces existing Ctext

        CTEXT <port> SAVE       - Saves ctext to CTEXTn.SYS

DESCRIPTION
        The CTEXT command displays or sets the "connect text" for
        the specified PORT. This is a single or multi-line text that
        can be sent to a caller when they connect to the port. The
        companion command CTFLAGS controls which callers receive the
        text.

        If a port-specific CTEXT exists, it overrides the global
        CTEXT, on that port only.

        Connect texts are usually configured using CTEXT directives
        in XROUTER.CFG. The CTEXT *command* allows the texts to be
        changed "on the fly".

        Upon bootup, if a port CTEXT is not specified in XROUTER.CFG,
        XRouter looks for the file CTEXTn.SYS, whcre n is the port
        number. If the file is found, the contents are loaded.
        Otherwise the global ctext (if any) is inherited by the port.

        If the contents of CTEXTn.SYS is changed during runtime,
        they can be reloaded into memory using the LOAD sub-command.
        Or if the text is changed using the CTEXT command, it can be
        stored for the future, using the SAVE sub-command.

        The CLEAR subcommand erases any text stored in memory.

        Single line ctexts can be added with either NEW or ADD. The
        former clears any existing text. The latter is OK if there
        is no existing text.

        If <text> specifies a filename, the contents of that file
        are read "live" every time someone connects, so this is
        ideal for "dynamic" ctexts. This may be of use in EMCOMM
        scenarios. That file could for instance be updated by another
        program, such as an extreme weather detector.

        If the filename starts with the 5 characters "CTEXT", e.g.
        "ctext-news", that file will be read from the current
        directory. If it is a fully qualified path starting with "."
        or "/", there are no restrictions on where the file resides,
        so long as XRouter is allowed to access it. For example,
        using the CTEXT command:

            CTEXT 5 new /etc/weather/latest.txt

            CTEXT 6 new ctext-news.txt

AVAILABILITY
        Sysop-only.

NOTE
        There is also a DIRECTIVE of the same name, used in
        XROUTER.CFG, which has a diffferent syntax.

SEE ALSO
        CTEXT(7)       -- Set "Connect Text".
        CTFLAGS(1)     -- Display / Set Connection Text Control Flags.
        CTFLAGS(7)     -- Connection Text Control Flags.
        XROUTER.CFG(8) -- Main Configuration File.

CTEXT(1)                 END OF DOCUMENT
