CTFLAGS(7)             XROUTER REFERENCE MANUAL               4/9/2023

NAME
        CTFLAGS -- Connection Text Control Flags.

SYNOPSIS
        CTFLAGS=n (where n is 0-15)

DESCRIPTION
        The CTFLAGS directive, used in XROUTER.CFG, controls which
        callers are sent a "connect text" when they connect to
        XRouter.

        If CTFLAGS is used in the GLOBAL section of XROUTER.CFG, its
        value is "inherited" by any PORTs that are subsequently
        defined.

        If used within a PORT block, the value overrides the global
        value, for that port only.

        The argument is the sum of the desired options from the
        following list (only options 1 and 2 are valid in a PORT):

           1 - Send CTEXT upon connection to NODEALIAS / PORTALIAS.
           2 - Send CTEXT upon connection to NODECALL / PORTCALL.
           4 - Send CTEXT to NetRom L4 callers.
           8 - Sent CTEXT to TELNET caller.

        The default value is 9 (Alias and Telnet only).

NOTE
        The CTFLAGS *command* allows the texts to be changed "on the
        fly".

SEE ALSO
        CTEXT(1)       -- Display / Set "Connect Text"
        CTEXT(7)       -- Connect Text configuration directive
        CTFLAGS(1)     -- Display / set Ctext control flags
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

CTFLAGS(7)                 END OF DOCUMENT
