DEDHOST(9)              XROUTER REFERENCE MANUAL            21/10/2023

NAME
        DEDHOST -- WA8DED Hostmode Emulation.

DESCRIPTION
        XRouter can emulate a WA8DED TNC, in both "normal" mode and
        "host" mode. This can be used for both manual operations and
        application support, just like a real TNC.  Many applications
        are capable of using WA8DED host mode. See the MAN page for
        WA8DED for details of normal emulation mode.

                .---------.                  .-----.
        User -->| XRouter |------RS232-------| BBS |
                '---------'                  '-----'

        The application may be located on the same machine as
        XRouter, connected to it either via a pair of "virtual" COM
        ports, or via a pair of "real" COM ports interconnected with
        a null-modem cable.

        Alternatively, the application may be located on a seperate
        machine, using an RS232 null-modem cable to interconnect the
        machines. 


        Configuring XRouter To Support Applications
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        1) Decide how to interconnect the application and XRouter.

           You can use either a pair of real COM ports and a
           null-modem cable, or a tty/pty pair 

        2) Add an INTERFACE.

           In XROUTER.CFG specify an interface similar to this, where
           "x" represents the interface number...
 
               INTERFACE=x
                    TYPE=ASYNC
                    COM=/dev/ttyUSB0
                    PROTOCOL=DEDHOST
                    APPLNUM=3
                    CHANNELS=4
                    SPEED=9600
                    FLOW=0
                    MTU=256
               ENDINTERFACE

           COM is the name of the serial device used to link to the
           application (on DOS / Windows this would be a COM number). 

           CHANNELS specifies the max no. of host channels the
           interface will provide (between 1 and 32). The total
           number of host channels available to be shared between all
           applications is 64. If XRouter cannot allocate the
           requested number of channels it will fail to start. (In
           versions up to 200e the number of channels was specified
           by INTNUM. This is now deprecated.) 

           MTU must be 256 

           APPLNUM (1-16???) specifies which application is using
           this interface. Corresponds to "n" in APPL=n (see below). 

           SPEED is the serial baud rate . Don't use too low a speed,
           otherwise badly-written applications may lose sync due to
           the time it takes for a poll to reach XRouter and the
           reply to reach the application. Speeds of 9600 and above
           should be OK. 

           FLOW must always be set to 0 or 4. Setting FLOW to any
           value other than 0 or 4 may cause the application or
           XRouter to hang. FLOW=4 is a special case which forces
           the WA8DED emulator to default to host mode (see later). 

           - Don't use CHANNEL, IOADDR, or INTNUM keywords. 

           - Don't try to attach any PORTs to this interface, as they
             are not required. 


        3) Define an Application:

           In XROUTER.CFG add an APPL=n block, to specify the
           application's callsign, alias, Netrom quality and
           visibility. The "n" parameter must match the APPLNUM
           specified in the INTERFACE block. For example: 

               APPL=3
                    APPLNAME=BBS
                    APPLCALL=GB7PZT
                    APPLALIAS=PZTBBS
                    APPLQUAL=100
                    APPLFLAGS=4
               ENDAPPL

           The application definition (APPL) block should contain one
           or more of the following keywords: 

           APPLNAME is the nickname or shortcut by which the
                    application is accessed from the XRouter's
                    command line. In the example above, if a user
                    types "BBS" at the command prompt, they will be
                    connected to the application. 

           APPLCALL is the AX25 layer 2 callsign which the
                    application will use.  If specified, the
                    application will accept AX25 L2 connects to this
                    callsign, subject to the setting of APPLMASK
                    (see below). 

           APPLALIAS is the AX25 layer 2 "alias" for use by the
                    application. If specified, the application will
                    accept AX25 L2 connects to this callsign, subject
                    to the setting of APPLMASK (see below). 

           APPLQUAL (0-255) is the Net/Rom quality to broadcast. If a
                    non-zero value is specified here, the APPLCALL
                    will be included in Net/Rom nodes broadcasts and
                    the application will be connectible at AX25 layer
                    4. The higher the quality, the further the node
                    entry will propogate. 

           APPLFLAGS defaults to 0 if omitted. A value of 4 instructs
                    XRouter to send "Connected to (applcall)" to the
                    user upon connection to an application. This may
                    be omitted if the application sends its own
                    "Connected to" message. 

           All fields within an application definition block are
           optional - you may have for instance choose to have an
           APPLNAME but no APPLCALL, meaning the application could
           only be reached by typing the applname at the command
           prompt. Or you could have an APPLCALL but no APPLNAME, in
           which case the application would be directly connectible,
           but wouldn't be reachable from a command line shortcut. 


        4) Set Application Visibility.

           In XROUTER.CFG set the APPLMASK on each PORT that you wish
           the application to appear on. The application will only
           monitor traffic and send UNPROTOs on the ports which have
           the application enabled via the APPLMASK.

           The APPLMASK parameter specifies which applications are
           directly connectible on a port. The default is 255, which
           allows all applications.  The value is made up by adding
           together the required options from the following numbers: 

                  1 - Enable Application 1  
                  2 - Enable Application 2  
                  4 - Enable Application 3  
                  8 - Enable Application 4  
                 16 - Enable Application 5  
                 32 - Enable Application 6  
                 64 - Enable Application 7  
                128 - Enable Application 8  

                Example: APPLMASK=5 (enable applications 1 and 3) 

           If you want an application to be directly connectible on a
           port, it must have either an APPLCALL or an APPLALIAS (or
           both), and the corresponding bit in that port's applmask
           must be set. 


        5) Configure The Application

           Finally, configure the application to use WA8DED hostmode
           on the other of the chosen COM port pair, with the same
           baud rate as specified in the INTERFACE block. 
 

        Default Mode
        ~~~~~~~~~~~~

        The default mode (host mode / terminal mode) is controlled by
        the FLOW parameter in the INTERFACE definition block. With
        FLOW=0, XRouter's WA8DED emulation starts in non-host
        ("terminal") mode because most applications expect it that
        way, therefore it allows them to sync up quickly. 

        However, some applications may expect the TNC to be in host
        mode, and may fail to sync if FLOW=0. In this case, setting
        FLOW=4 forces the WA8DED "TNC" to start in host mode. 

        This control is not a panacea. For example, If XRouter is
        stopped and restarted while an application is running in
        hostmode, everything should quickly sync up again if FLOW=4.
        But this setting may prevent the application from syncing up
        from cold. 

 
        Starting / Stopping Applications
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Where possible, XRouter should be started before the
        application, and stopped after it, because some applications
        malfunction if they don't see the expected responses when
        they start up and shut down. 

        If an application doesn't close down "cleanly", it may take a
        while to resync when it restarts. This is normal. 

 
        Hidden Applications
        ~~~~~~~~~~~~~~~~~~~

        If you have an application that only makes outgoing
        connections, you can omit the APPL block altogether. The
        application will still work, but it won't accept incoming
        connects. 

 
        Known Issues
        ~~~~~~~~~~~~

        a) FBB 16-bit versions 700g and 700i use 100% CPU when
           configured for WA8DED hostmode. The BBS seems to work OK
           despite this.  Although this is not an XRouter issue, we
           are looking at ways to fix the problem.

        b) WinFBB v701-35 often reports "Error initialising WA8DED
           Driver" and fails to communicate with XRouter after that.
           It usually boots cleanly if stopped and restarted.  The
           best setting for FLOW is 0.

        c) With WinFBB v701-35, the sysop is able to open a gateway
           connection to XRouter's command processor and make
           outgoing connections.  However, whilst incoming
           connections are accepted, WinFBB only sends the SID
           [FBB-701-ABFHMR$] and nothing else. It doesn't respond to
           any command.

        d) If XRouter is stopped and restarted within a short time,
           WinFBB v701-35 will resync cleanly. However, if too long
           an interval elapses before XRouter restarts, WinFBB goes
           into meltdown and will never resync.

        e) Although WinFBB 701-35 appears to run in DED mode, it
           doesn't run properly, and is therefore unusable as a BBS
           in this mode.

        f) If Com0Com is used without the "enable buffer overrun"
           option checked, closing the application may sometimes
           cause XRouter to hang until the application is restarted. 
 

        Breaking out of host mode
        ~~~~~~~~~~~~~~~~~~~~~~~~~

        If the emulator is inadvertently switched into, or left in,
        host mode it can be easily be returned to terminal mode using
        Hyperterm as follows: 

        - Send ctrl-a's slowly (1 or 2 per sec) until "INVALID
          COMMAND" appears (it may take up to 256 ctrl-a's to make
          this happen, but usually it will take a lot less). Stop
          sending ctrl-a's as soon as the response appears. If you
          inadvertently send one or two too many, *slowly* send up to
          4 more ctrl-a's and the message should appear again.

        - Send JHOST0 (there will be no response)

        - Send <esc> and it should display the "* " to indicate that
          it is in command mode. 
  

        Troubleshooting
        ~~~~~~~~~~~~~~~

        1) XRouter reports "All Host Ports in use" upon first attempt
           to connect to DEDHOST application:

           - The APPLNUM in the INTERFACE definition block does not
             match the application number specified in the APPL
             definition block. 

        2) Application frequently loses sync:

           - Serial port baud rate too low?
             If the baud rate is too low, the data may take too long
             to propogate back and forth between XRouter and the
             application, causing the application to think it has
             lost sync.  Good applications would adjust their polling
             rate according to the baud rate.  Unfortunately some
             don't!

           - Serial port baud rate too high?
             If the baud rate is too high the serial line may drop
             characters, causing loss of sync. Another, more likely,
             issue is that with high baud rates the "timeout" between
             the application sending a poll and expecting a reply may
             be too short for a multitasking operating system, even
             though it is OK for a firmware TNC.

           - FLOW not set to 0 or 4

           - The PC is too busy.
             Unlike a real TNC, XRouter does not have sole use of the
             CPU. Other processes may "steal" CPU time, causing a
             delay in responding to the application's polls. In most
             cases this shouldn't happen, but some applications poll
             too fast. The only solution is to avoid running
             CPU-hungry applications on the same PC.

           - Excessive tracing on XRouter's console.
             Writing characters to the console is very CPU-intensive,
             so having MON ON can cause delays in the poll-response
             cycle if the amount of trace traffic is heavy. Turning
             MON OFF or tracing fewer ports should alleviate the
             problem.

        3) XRouter hangs when application is stopped:

           - XRouter's RS232 output buffer is full and something is
             preventing it from emptying. - If using Com0Com virtual
             COM port emulator, check the "Enable buffer overrun"
             boxes - Use FLOW=0.
 
        4) Application won't sync if XRouter is stopped and restarted

           - XRouter's DEDHOST emulation starts in non-host mode
             because most applications expect it that way. This
             allows them to sync up quickly when they are started
             AFTER XRouter.  However, if XRouter is restarted while
             the application is running, the application won't know
             that XRouter is back in non-host mode, and will fail to
             sync. 

        5) Can't connect to application on port N / Can't monitor
           port N

           - The port's APPLMASK is not set correctly (see above for
             description of APPLMASK)

           - There is a bug in early versions - Although up to 16
             applications are allowed, if APPLNUM is more than 8, the
             application cannot be connected to.

        6) Application is monitoring port N uncesessarily.

           - The default APPLMASK setting for each port allows access
             to, and monitoring by, all applications. If you wish to
             suppress connections and monitoring on a particular
             port, you must set APPLMASK accordingly. To suppress all
             applications, set the port's APPLMASK to 0. 


        Random Factoids...
        ~~~~~~~~~~~~~~~~~ 

        - Uplinks and downlinks to DEDHOST applications show as link
          type "DED" on XRouter's "Users" display. 

SEE ALSO
        WA8DED(9)      -- WA8DED TNC Emulation.
        XROUTER.CFG(8) -- Main Configuration File.

DEDHOST(9)                  END OF DOCUMENT
