DHCP(9)                 XROUTER REFERENCE MANUAL            21/10/2023

NAME
        DHCP -- Dynamic Host Configuration Protocol.

DESCRIPTION
        The acronym DHCP stands for Dynamic Host Configuration
        Protocol.  This is a client-server based protocol which
        allows clients on a TCP/IP network to obtain their
        configuration parameters from a server.

        The protocol supports the transfer of a wide range of
        configuration parameters such as the client's IP address,
        netmask, DNS and gateway addresses, plus TCP/IP parameters
        such as MSS, but is most commonly used to allocate dynamic
        IP addresses to clients.

        IP addresses are "leased" to clients for a period of time,
        after which the client must renew the lease.  Servers
        generally attempt to re-assign the same IP address to the
        same client.


        DHCP in XRouter
        ~~~~~~~~~~~~~~~

        XRouter includes a DHCP client, and a DHCP server may be
        included in future, if the need arises.  The full range of
        configuration options is not supported, since in most XRouter
        application scenarios they are not required.  The options
        currently supported are client's IP address and lease time,
        DNS and gateway IP addresses.

        The DHCP client is available only on Ethernet interfaces
        which are using the EXTERNAL driver.  Lease negotiation and
        renewal are completely automatic, and the sysop need not be
        concerned with the process.


        Do you need DHCP?
        ~~~~~~~~~~~~~~~~~

        If you wish to connect XRouter to an ISP via a cable modem,
        e.g. to use it as an Internet Connection Sharing router, you
        will probably need DHCP if your ISP uses dynamic IP
        addressing.  However, if your ISP assigns you a static IP
        address you won't need DHCP.

        You will not need DHCP if your connection to the ISP is via
        dial-up PPP, because dynamic IP addresses are assigned as
        part of the PPP negotiation process.

        *** The above scenarios date back to the time when domestic
        routers had not yet become commonplace, when Windows
        "Internet Connection Sharing" was in its unreliable infancy,
        and XRouter was running on DOS machines.  Nowadays, with
        modern ADSL and cable routers, and proper TCP/IP built into
        Windows, it is unlikely that XRouter would be required to
        provide the Internet Connection Sharing service.

        The only reason you might wish to use DHCP these days is to
        obtain a dynamic LAN IP address from your domestic router,
        but this is not recommended practice. It is far better to use
        static IP addresses when feasible, especially when you are
        "port-forwarding" TCP and UDP ports to specific machines.

        You do not need DHCP for normal amateur radio operations.


        Enabling DHCP
        ~~~~~~~~~~~~~

        In XROUTER.CFG, put "DHCP=1" in the appropriate port
        definition block.  There is no need to specify a port
        IPADDRESS because one will be assigned by the DHCP server. 

        If however, a port IPADDRESS is specified (or it is not
        specified but a global IP address is specified), that address
        will be used for non-DHCP traffic until DHCP succeeds in
        leasing a (possibly different) address.  If the global
        IPADDRESS is 0.0.0.0 or not specified, it will be assigned
        by the first client which obtains a lease.

        To disable DHCP, put "DHCP=0" in the PORT definition block,
        or simply omit the keyword altogether.

        The DHCP command displays DHCP status information, and is
        detailed in DHCP(1).

SEE ALSO
        DHCP(1)        -- DHCP Commands.
        DHCP(7)        -- Obtain Port IP Using DHCP.
        XROUTER.CFG(8) -- Main Configuration File.

DHCP(9)                     END OF DOCUMENT
