DHCP(1)                 XROUTER REFERENCE MANUAL            21/10/2023

COMMAND
        DHCP -- Display DHCP-obtained IP configuration parameters.

SYNOPSIS
        DHCP <port> [bind | release | trace n]

AVAILABILITY
        Sysop-only

DESCRIPTION
        For ports on which the DHCP Dynamic Host Configuration 
        Protocol) client is enabled, the DHCP command displays the
        IP configuration parameters which have been obtained via DHCP.

        Parameters displayed include: IP address, DHCP server 
        address, gateway IP address, primary DNS address, lease 
        expiry time, and DHCP state.

        States are as follows:

            INIT        - Initial state, no IP address yet.
            SELECTING   - Awaiting offers from sever(s)
            REQUESTING  - Client requests chosen address
            BOUND       - Lease obtained, OK to use.
            RENEWING    - Requesting lease renewal.
            REBINDING   - No response, locating new server

OPTIONS
        When the only argument is a port number, the DHCP settings
        for that port are displayed.

        The BIND option isn't curently implemented, as the client
        automatically binds.

        The RELEASE option forces the client to release the current
        configuration.

        The TRACE option displays or sets the DHCP trace flags. Use
        a non-zero value to enable tracing, or zero to disable it.
        Tracing is enabled by default.

EXAMPLES
        DHCP 3          - Display DHCP settings for port 3
        DHCP 3 RELEASE  - Relinquish port 3 lease.
        DHCP 3 TRACE 0  - Disable DHCP tracing on port 3

FILES
        DHCP is enabled by including the "DHCP=1" directive in the
        relevant PORT block within XROUTER.CFG.

CAVEATS
        The use of dynamic IP addressing for XRouter is strongly
        deprecated, as so many of its servers and protocols require
        "port forwarding", which is difficult when the IP address
        keeps changing!
      
DHCP(1)                     END OF DOCUMENT
