;*************************** Max Width *******************************
DIGIFLAG(7)            XROUTER REFERENCE MANUAL              24/9/2023

NAME
        DIGIFLAG -- Digipeating Options.

SYNOPSIS
        DIGIFLAG=n (where n is a number from 0 to 1023)

DESCRIPTION
        DIGIFLAG is an optional PORT configuraton directive which
        controls digipeating on that port. (0=none, default=7).

OPTIONS
        Options are enabled by adding together the following numbers:

           Value Option
            ---------------------------------------------------
             1   Digipeat UI frames
             2   Digipeat non-UI frames
             4   Enable RELAY generic digipeating (deprecated).
             8   Enable TRACE generic digipeating (deprecated).
            16   Enable WIDE generic digipeating (deprecated).
            32   Allow APRS 3rd party digi via L4.
            64   Allow digipeating to Internet (IGate).
           128   Allow digipeating from Internet (IGate).
           256   Enable UITRACE digipeating (e.g. WIDEn-n)
           512   Enable UIFLOOD digipeating (e.g. GBRn-n)

EXAMPLE
        DIGIFLAG=5      ; Digipeat UI + RELAY generic.

NOTES
        UITRACE and UIFLOOD are two special addresses that are
        suffixed with pseudo-SSID's, e.g. "TRACE4-4" and "WIDE2-2".
        These addresses can digipeat several times. The first digit
        specifies the maximum number of hops, and the second is the
        hop counter, which is decremented each time the frame is
        digipeated.

        These two addresses behave slightly differently however. When
        a frame is digipeated on the address specified by UITRACE,
        each digipeater inserts its own callsign in the digipeater
        list and decrements the "SSID". Frames digipeated on the
        UIFLOOD address have their SSIDs decremented, but the digi
        doesn't insert its own callsign. 

        For the sake of consistency with UI-View, UITRACE defaults
        to "TRACE", giving TRACEn-n digipeating, and UIFLOOD
        defaults to WIDE, giving WIDEn-n digipeating.

        However, according to the APRS "New Paradigm", RELAY, TRACE
        and WIDE are deprecated, UITRACE should be set to "WIDE",
        and UIFLOOD should be set to a "state" code (e.g. "GBR" for
        the UK). These addressses may be specified in XROUTER.CFG.

        One of the main justifications for the new paradigm was the
        fact that some of the older digipeaters would repeat the same
        packets over and over. This does not happen with XRouter, due
        to its duplicate prevention measures.

        Not everyone agrees with the "New Paradigm, so the choice of
        which features to enable is left you you.
 
SEE ALSO
        DIGIFLAG(1)    -- Display / Set digipeat options.
        DIGIPORT(7)    -- Destination Port for Digipeating.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

DIGIFLAG(7)                  END OF DOCUMENT
